/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util;

import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lease.Releasable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lease.Releasables;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.BigArrays;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.LongArray;

public final class BitArray
implements Releasable {
    private final BigArrays bigArrays;
    private LongArray bits;

    public BitArray(long initialSize, BigArrays bigArrays) {
        this.bigArrays = bigArrays;
        this.bits = bigArrays.newLongArray(BitArray.wordNum(initialSize) + 1L, true);
    }

    public void set(long index) {
        long wordNum = BitArray.wordNum(index);
        this.bits = this.bigArrays.grow(this.bits, wordNum + 1L);
        this.bits.set(wordNum, this.bits.get(wordNum) | BitArray.bitmask(index));
    }

    public void or(BitArray other) {
        this.or(other.bits);
    }

    private void or(LongArray otherArr) {
        long pos = otherArr.size();
        LongArray thisArr = this.bits = this.bigArrays.grow(this.bits, pos + 1L);
        while (--pos >= 0L) {
            thisArr.set(pos, thisArr.get(pos) | otherArr.get(pos));
        }
    }

    public long nextSetBit(long index) {
        long wordNum = BitArray.wordNum(index);
        if (wordNum >= this.bits.size()) {
            return Long.MAX_VALUE;
        }
        long word = this.bits.get(wordNum) >> (int)index;
        if (word != 0L) {
            return index + (long)Long.numberOfTrailingZeros(word);
        }
        while (++wordNum < this.bits.size()) {
            word = this.bits.get(wordNum);
            if (word == 0L) continue;
            return (wordNum << 6) + (long)Long.numberOfTrailingZeros(word);
        }
        return Long.MAX_VALUE;
    }

    public void clear(long index) {
        long wordNum = BitArray.wordNum(index);
        if (wordNum >= this.bits.size()) {
            return;
        }
        this.bits.set(wordNum, this.bits.get(wordNum) & (BitArray.bitmask(index) ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public boolean get(long index) {
        long wordNum = BitArray.wordNum(index);
        if (wordNum >= this.bits.size()) {
            return false;
        }
        long bitmask = 1L << (int)index;
        return (this.bits.get(wordNum) & bitmask) != 0L;
    }

    private static long wordNum(long index) {
        return index >> 6;
    }

    private static long bitmask(long index) {
        return 1L << (int)index;
    }

    @Override
    public void close() {
        Releasables.close((Releasable)this.bits);
    }
}

