/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.transform.transforms;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class SettingsConfig
implements ToXContentObject {
    private static final ParseField MAX_PAGE_SEARCH_SIZE = new ParseField("max_page_search_size", new String[0]);
    private static final ParseField DOCS_PER_SECOND = new ParseField("docs_per_second", new String[0]);
    private static final int DEFAULT_MAX_PAGE_SEARCH_SIZE = -1;
    private static final float DEFAULT_DOCS_PER_SECOND = -1.0f;
    private final Integer maxPageSearchSize;
    private final Float docsPerSecond;
    private static final ConstructingObjectParser<SettingsConfig, Void> PARSER = new ConstructingObjectParser("settings_config", true, args -> new SettingsConfig((Integer)args[0], (Float)args[1]));

    public static SettingsConfig fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    SettingsConfig(Integer maxPageSearchSize, Float docsPerSecond) {
        this.maxPageSearchSize = maxPageSearchSize;
        this.docsPerSecond = docsPerSecond;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.maxPageSearchSize != null) {
            if (this.maxPageSearchSize.equals(-1)) {
                builder.field(MAX_PAGE_SEARCH_SIZE.getPreferredName(), (Integer)null);
            } else {
                builder.field(MAX_PAGE_SEARCH_SIZE.getPreferredName(), this.maxPageSearchSize);
            }
        }
        if (this.docsPerSecond != null) {
            if (this.docsPerSecond.equals(Float.valueOf(-1.0f))) {
                builder.field(DOCS_PER_SECOND.getPreferredName(), (Float)null);
            } else {
                builder.field(DOCS_PER_SECOND.getPreferredName(), this.docsPerSecond);
            }
        }
        builder.endObject();
        return builder;
    }

    public Integer getMaxPageSearchSize() {
        return this.maxPageSearchSize;
    }

    public Float getDocsPerSecond() {
        return this.docsPerSecond;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        SettingsConfig that = (SettingsConfig)other;
        return Objects.equals(this.maxPageSearchSize, that.maxPageSearchSize) && Objects.equals(this.docsPerSecond, that.docsPerSecond);
    }

    public int hashCode() {
        return Objects.hash(this.maxPageSearchSize, this.docsPerSecond);
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PARSER.declareIntOrNull(ConstructingObjectParser.optionalConstructorArg(), -1, MAX_PAGE_SEARCH_SIZE);
        PARSER.declareFloatOrNull(ConstructingObjectParser.optionalConstructorArg(), -1.0f, DOCS_PER_SECOND);
    }

    public static class Builder {
        private Integer maxPageSearchSize;
        private Float docsPerSecond;

        public Builder setMaxPageSearchSize(Integer maxPageSearchSize) {
            this.maxPageSearchSize = maxPageSearchSize == null ? -1 : maxPageSearchSize;
            return this;
        }

        public Builder setRequestsPerSecond(Float docsPerSecond) {
            this.docsPerSecond = Float.valueOf(docsPerSecond == null ? -1.0f : docsPerSecond.floatValue());
            return this;
        }

        public SettingsConfig build() {
            return new SettingsConfig(this.maxPageSearchSize, this.docsPerSecond);
        }
    }
}

