/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.rollup;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Validatable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class GetRollupIndexCapsRequest
implements Validatable,
ToXContentObject {
    private static final String INDICES = "indices";
    private static final String INDICES_OPTIONS = "indices_options";
    private String[] indices;
    private IndicesOptions options;

    public GetRollupIndexCapsRequest(String ... indices) {
        this(indices, IndicesOptions.STRICT_EXPAND_OPEN_FORBID_CLOSED);
    }

    public GetRollupIndexCapsRequest(String[] indices, IndicesOptions options) {
        if (indices == null || indices.length == 0) {
            throw new IllegalArgumentException("[indices] must not be null or empty");
        }
        for (String index : indices) {
            if (!Strings.isNullOrEmpty(index)) continue;
            throw new IllegalArgumentException("[index] must not be null or empty");
        }
        this.indices = indices;
        this.options = Objects.requireNonNull(options);
    }

    public IndicesOptions indicesOptions() {
        return this.options;
    }

    public String[] indices() {
        return this.indices;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.array(INDICES, this.indices);
        builder.startObject(INDICES_OPTIONS);
        this.options.toXContent(builder, params);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.indices), this.options);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetRollupIndexCapsRequest other = (GetRollupIndexCapsRequest)obj;
        return Arrays.equals(this.indices, other.indices) && Objects.equals(this.options, other.options);
    }
}

