/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.analytics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParserUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.ParsedAggregation;

public class ParsedTopMetrics
extends ParsedAggregation {
    private static final ParseField TOP_FIELD = new ParseField("top", new String[0]);
    private final List<TopMetrics> topMetrics;
    public static final ConstructingObjectParser<ParsedTopMetrics, String> PARSER = new ConstructingObjectParser<ParsedTopMetrics, String>("top_metrics", true, (args, name) -> {
        List topMetrics = (List)args[0];
        return new ParsedTopMetrics((String)name, topMetrics);
    });

    private ParsedTopMetrics(String name, List<TopMetrics> topMetrics) {
        this.setName(name);
        this.topMetrics = topMetrics;
    }

    public List<TopMetrics> getTopMetrics() {
        return this.topMetrics;
    }

    @Override
    public String getType() {
        return "top_metrics";
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(TOP_FIELD.getPreferredName());
        for (TopMetrics top : this.topMetrics) {
            top.toXContent(builder, params);
        }
        return builder.endArray();
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> (TopMetrics)TopMetrics.PARSER.parse(p, null), TOP_FIELD);
        ParsedAggregation.declareAggregationFields(PARSER);
    }

    public static class TopMetrics
    implements ToXContent {
        private static final ParseField SORT_FIELD = new ParseField("sort", new String[0]);
        private static final ParseField METRICS_FIELD = new ParseField("metrics", new String[0]);
        private final List<Object> sort;
        private final Map<String, Object> metrics;
        private static final ConstructingObjectParser<TopMetrics, Void> PARSER = new ConstructingObjectParser<TopMetrics, Void>("top", true, (args, name) -> {
            List sort = (List)args[0];
            Map metrics = (Map)args[1];
            return new TopMetrics(sort, metrics);
        });

        private TopMetrics(List<Object> sort, Map<String, Object> metrics) {
            this.sort = sort;
            this.metrics = metrics;
        }

        public List<Object> getSort() {
            return this.sort;
        }

        public Map<String, Object> getMetrics() {
            return this.metrics;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(SORT_FIELD.getPreferredName(), this.sort);
            builder.field(METRICS_FIELD.getPreferredName(), this.metrics);
            builder.endObject();
            return builder;
        }

        static {
            PARSER.declareFieldArray(ConstructingObjectParser.constructorArg(), (p, c) -> XContentParserUtils.parseFieldsValue(p), SORT_FIELD, ObjectParser.ValueType.VALUE_ARRAY);
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), METRICS_FIELD);
        }
    }
}

