/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Cancellable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.EnrichRequestConverters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.RequestOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.RestHighLevelClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.core.AcknowledgedResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.enrich.DeletePolicyRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.enrich.ExecutePolicyRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.enrich.ExecutePolicyResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.enrich.GetPolicyRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.enrich.GetPolicyResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.enrich.PutPolicyRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.enrich.StatsRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.enrich.StatsResponse;

public final class EnrichClient {
    private final RestHighLevelClient restHighLevelClient;

    EnrichClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public AcknowledgedResponse putPolicy(PutPolicyRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, EnrichRequestConverters::putPolicy, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable putPolicyAsync(PutPolicyRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, EnrichRequestConverters::putPolicy, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse deletePolicy(DeletePolicyRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, EnrichRequestConverters::deletePolicy, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable deletePolicyAsync(DeletePolicyRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, EnrichRequestConverters::deletePolicy, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetPolicyResponse getPolicy(GetPolicyRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, EnrichRequestConverters::getPolicy, options, GetPolicyResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable getPolicyAsync(GetPolicyRequest request, RequestOptions options, ActionListener<GetPolicyResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, EnrichRequestConverters::getPolicy, options, GetPolicyResponse::fromXContent, listener, Collections.emptySet());
    }

    public StatsResponse stats(StatsRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, EnrichRequestConverters::stats, options, StatsResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable statsAsync(StatsRequest request, RequestOptions options, ActionListener<StatsResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, EnrichRequestConverters::stats, options, StatsResponse::fromXContent, listener, Collections.emptySet());
    }

    public ExecutePolicyResponse executePolicy(ExecutePolicyRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, EnrichRequestConverters::executePolicy, options, ExecutePolicyResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable executePolicyAsync(ExecutePolicyRequest request, RequestOptions options, ActionListener<ExecutePolicyResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, EnrichRequestConverters::executePolicy, options, ExecutePolicyResponse::fromXContent, listener, Collections.emptySet());
    }
}

