/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.template.post;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.Template;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class SimulateIndexTemplateResponse
extends ActionResponse
implements ToXContentObject {
    private static final ParseField TEMPLATE = new ParseField("template", new String[0]);
    private static final ParseField OVERLAPPING = new ParseField("overlapping", new String[0]);
    private static final ParseField NAME = new ParseField("name", new String[0]);
    private static final ParseField INDEX_PATTERNS = new ParseField("index_patterns", new String[0]);
    @Nullable
    private Template resolvedTemplate;
    @Nullable
    private Map<String, List<String>> overlappingTemplates;

    public SimulateIndexTemplateResponse(@Nullable Template resolvedTemplate, @Nullable Map<String, List<String>> overlappingTemplates) {
        this.resolvedTemplate = resolvedTemplate;
        this.overlappingTemplates = overlappingTemplates;
    }

    public SimulateIndexTemplateResponse(StreamInput in) throws IOException {
        super(in);
        this.resolvedTemplate = in.readOptionalWriteable(Template::new);
        if (in.readBoolean()) {
            int overlappingTemplatesCount = in.readInt();
            this.overlappingTemplates = new HashMap<String, List<String>>(overlappingTemplatesCount, 1.0f);
            for (int i = 0; i < overlappingTemplatesCount; ++i) {
                String templateName = in.readString();
                this.overlappingTemplates.put(templateName, in.readStringList());
            }
        } else {
            this.overlappingTemplates = null;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.resolvedTemplate);
        if (this.overlappingTemplates != null) {
            out.writeBoolean(true);
            out.writeInt(this.overlappingTemplates.size());
            for (Map.Entry<String, List<String>> entry : this.overlappingTemplates.entrySet()) {
                out.writeString(entry.getKey());
                out.writeStringCollection((Collection<String>)entry.getValue());
            }
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.resolvedTemplate != null) {
            builder.field(TEMPLATE.getPreferredName(), this.resolvedTemplate);
        }
        if (this.overlappingTemplates != null) {
            builder.startArray(OVERLAPPING.getPreferredName());
            for (Map.Entry<String, List<String>> entry : this.overlappingTemplates.entrySet()) {
                builder.startObject();
                builder.field(NAME.getPreferredName(), entry.getKey());
                builder.field(INDEX_PATTERNS.getPreferredName(), (Iterable)entry.getValue());
                builder.endObject();
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimulateIndexTemplateResponse that = (SimulateIndexTemplateResponse)o;
        return Objects.equals(this.resolvedTemplate, that.resolvedTemplate) && Objects.deepEquals(this.overlappingTemplates, that.overlappingTemplates);
    }

    public int hashCode() {
        return Objects.hash(this.resolvedTemplate, this.overlappingTemplates);
    }

    public String toString() {
        return "SimulateIndexTemplateResponse{resolved template=" + this.resolvedTemplate + ", overlapping templates=" + String.join((CharSequence)"|", this.overlappingTemplates.keySet()) + "}";
    }
}

