/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial.spatial4j;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial.spatial4j.Geo3dPointShape;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoPointShape;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.distance.DistanceCalculator;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;

public class Geo3dDistanceCalculator
implements DistanceCalculator {
    protected final PlanetModel planetModel;

    public Geo3dDistanceCalculator(PlanetModel planetModel) {
        this.planetModel = planetModel;
    }

    public double distance(Point from, Point to) {
        if (from instanceof Geo3dPointShape && to instanceof Geo3dPointShape) {
            GeoPointShape pointShape1 = (GeoPointShape)((Geo3dPointShape)from).shape;
            GeoPointShape pointShape2 = (GeoPointShape)((Geo3dPointShape)to).shape;
            return this.planetModel.surfaceDistance(pointShape1.getCenter(), pointShape2.getCenter()) * 57.29577951308232;
        }
        return this.distance(from, to.getX(), to.getY());
    }

    public double distance(Point from, double toX, double toY) {
        GeoPoint fromGeoPoint = from instanceof Geo3dPointShape ? ((GeoPointShape)((Geo3dPointShape)from).shape).getCenter() : new GeoPoint(this.planetModel, from.getY() * (Math.PI / 180), from.getX() * (Math.PI / 180));
        GeoPoint toGeoPoint = new GeoPoint(this.planetModel, toY * (Math.PI / 180), toX * (Math.PI / 180));
        return this.planetModel.surfaceDistance(fromGeoPoint, toGeoPoint) * 57.29577951308232;
    }

    public boolean within(Point from, double toX, double toY, double distance) {
        return distance < this.distance(from, toX, toY);
    }

    public Point pointOnBearing(Point from, double distDEG, double bearingDEG, SpatialContext ctx, Point reuse) {
        Geo3dPointShape geoFrom = (Geo3dPointShape)from;
        GeoPoint point = (GeoPoint)((Object)geoFrom.shape);
        double dist = Math.PI / 180 * distDEG;
        double bearing = Math.PI / 180 * bearingDEG;
        GeoPoint newPoint = this.planetModel.surfacePointOnBearing(point, dist, bearing);
        double newLat = newPoint.getLatitude() * 57.29577951308232;
        double newLon = newPoint.getLongitude() * 57.29577951308232;
        if (reuse != null) {
            reuse.reset(newLon, newLat);
            return reuse;
        }
        return ctx.getShapeFactory().pointXY(newLon, newLat);
    }

    public Rectangle calcBoxByDistFromPt(Point from, double distDEG, SpatialContext ctx, Rectangle reuse) {
        Circle circle = ctx.getShapeFactory().circle(from, distDEG);
        return circle.getBoundingBox();
    }

    public double calcBoxByDistFromPt_yHorizAxisDEG(Point from, double distDEG, SpatialContext ctx) {
        throw new UnsupportedOperationException();
    }

    public double area(Rectangle rect) {
        throw new UnsupportedOperationException();
    }

    public double area(Circle circle) {
        throw new UnsupportedOperationException();
    }
}

