/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.spans.ConjunctionSpans;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.spans.SpanCollector;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.spans.Spans;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.PriorityQueue;

public class NearSpansUnordered
extends ConjunctionSpans {
    private final int allowedSlop;
    private SpanTotalLengthEndPositionWindow spanWindow;

    public NearSpansUnordered(int allowedSlop, List<Spans> subSpans) throws IOException {
        super(subSpans);
        this.allowedSlop = allowedSlop;
        this.spanWindow = new SpanTotalLengthEndPositionWindow();
    }

    static boolean positionsOrdered(Spans spans1, Spans spans2) {
        int start2;
        assert (spans1.docID() == spans2.docID()) : "doc1 " + spans1.docID() + " != doc2 " + spans2.docID();
        int start1 = spans1.startPosition();
        return start1 == (start2 = spans2.startPosition()) ? spans1.endPosition() < spans2.endPosition() : start1 < start2;
    }

    @Override
    boolean twoPhaseCurrentDocMatches() throws IOException {
        this.spanWindow.startDocument();
        do {
            if (!this.spanWindow.atMatch()) continue;
            this.atFirstInCurrentDoc = true;
            this.oneExhaustedInCurrentDoc = false;
            return true;
        } while (this.spanWindow.nextPosition());
        return false;
    }

    @Override
    public int nextStartPosition() throws IOException {
        if (this.atFirstInCurrentDoc) {
            this.atFirstInCurrentDoc = false;
            return ((Spans)this.spanWindow.top()).startPosition();
        }
        assert (((Spans)this.spanWindow.top()).startPosition() != -1);
        assert (((Spans)this.spanWindow.top()).startPosition() != Integer.MAX_VALUE);
        do {
            if (this.spanWindow.nextPosition()) continue;
            this.oneExhaustedInCurrentDoc = true;
            return Integer.MAX_VALUE;
        } while (!this.spanWindow.atMatch());
        return ((Spans)this.spanWindow.top()).startPosition();
    }

    @Override
    public int startPosition() {
        assert (this.spanWindow.top() != null);
        return this.atFirstInCurrentDoc ? -1 : (this.oneExhaustedInCurrentDoc ? Integer.MAX_VALUE : ((Spans)this.spanWindow.top()).startPosition());
    }

    @Override
    public int endPosition() {
        return this.atFirstInCurrentDoc ? -1 : (this.oneExhaustedInCurrentDoc ? Integer.MAX_VALUE : this.spanWindow.maxEndPosition);
    }

    @Override
    public int width() {
        return this.spanWindow.maxEndPosition - ((Spans)this.spanWindow.top()).startPosition();
    }

    @Override
    public void collect(SpanCollector collector) throws IOException {
        for (Spans spans : this.subSpans) {
            spans.collect(collector);
        }
    }

    private class SpanTotalLengthEndPositionWindow
    extends PriorityQueue<Spans> {
        int totalSpanLength;
        int maxEndPosition;

        public SpanTotalLengthEndPositionWindow() {
            super(NearSpansUnordered.this.subSpans.length);
        }

        @Override
        protected final boolean lessThan(Spans spans1, Spans spans2) {
            return NearSpansUnordered.positionsOrdered(spans1, spans2);
        }

        void startDocument() throws IOException {
            this.clear();
            this.totalSpanLength = 0;
            this.maxEndPosition = -1;
            for (Spans spans : NearSpansUnordered.this.subSpans) {
                assert (spans.startPosition() == -1);
                spans.nextStartPosition();
                assert (spans.startPosition() != Integer.MAX_VALUE);
                this.add(spans);
                if (spans.endPosition() > this.maxEndPosition) {
                    this.maxEndPosition = spans.endPosition();
                }
                int spanLength = spans.endPosition() - spans.startPosition();
                assert (spanLength >= 0);
                this.totalSpanLength += spanLength;
            }
        }

        boolean nextPosition() throws IOException {
            Spans topSpans = (Spans)this.top();
            assert (topSpans.startPosition() != Integer.MAX_VALUE);
            int spanLength = topSpans.endPosition() - topSpans.startPosition();
            int nextStartPos = topSpans.nextStartPosition();
            if (nextStartPos == Integer.MAX_VALUE) {
                return false;
            }
            this.totalSpanLength -= spanLength;
            spanLength = topSpans.endPosition() - topSpans.startPosition();
            this.totalSpanLength += spanLength;
            if (topSpans.endPosition() > this.maxEndPosition) {
                this.maxEndPosition = topSpans.endPosition();
            }
            this.updateTop();
            return true;
        }

        boolean atMatch() {
            boolean res = this.maxEndPosition - ((Spans)this.top()).startPosition() - this.totalSpanLength <= NearSpansUnordered.this.allowedSlop;
            return res;
        }
    }
}

