/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.com.github.mustachejava.resolver;

import java.io.File;
import java.io.Reader;
import org.apache.flink.elasticsearch7.shaded.com.github.mustachejava.MustacheResolver;
import org.apache.flink.elasticsearch7.shaded.com.github.mustachejava.resolver.ClasspathResolver;
import org.apache.flink.elasticsearch7.shaded.com.github.mustachejava.resolver.FileSystemResolver;

public class DefaultResolver
implements MustacheResolver {
    private final ClasspathResolver classpathResolver;
    private final FileSystemResolver fileSystemResolver;

    public DefaultResolver() {
        this.fileSystemResolver = new FileSystemResolver();
        this.classpathResolver = new ClasspathResolver();
    }

    public DefaultResolver(String resourceRoot) {
        this.classpathResolver = new ClasspathResolver(resourceRoot);
        this.fileSystemResolver = new FileSystemResolver();
    }

    public DefaultResolver(File fileRoot) {
        this.fileSystemResolver = new FileSystemResolver(fileRoot);
        this.classpathResolver = new ClasspathResolver();
    }

    @Override
    public Reader getReader(String resourceName) {
        Reader reader = this.classpathResolver.getReader(resourceName);
        if (reader == null) {
            reader = this.fileSystemResolver.getReader(resourceName);
        }
        return reader;
    }
}

