/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.NumericDocValues;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.ReaderUtil;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.SearchHit;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.FetchSubPhase;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.internal.SearchContext;

public final class SeqNoPrimaryTermFetchSubPhase
implements FetchSubPhase {
    @Override
    public void hitsExecute(SearchContext context, SearchHit[] hits) throws IOException {
        if (!context.seqNoAndPrimaryTerm()) {
            return;
        }
        hits = (SearchHit[])hits.clone();
        Arrays.sort(hits, Comparator.comparingInt(SearchHit::docId));
        int lastReaderId = -1;
        NumericDocValues seqNoField = null;
        NumericDocValues primaryTermField = null;
        for (SearchHit hit : hits) {
            int readerId = ReaderUtil.subIndex(hit.docId(), context.searcher().getIndexReader().leaves());
            LeafReaderContext subReaderContext = context.searcher().getIndexReader().leaves().get(readerId);
            if (lastReaderId != readerId) {
                seqNoField = subReaderContext.reader().getNumericDocValues("_seq_no");
                primaryTermField = subReaderContext.reader().getNumericDocValues("_primary_term");
                lastReaderId = readerId;
            }
            int docId = hit.docId() - subReaderContext.docBase;
            long seqNo = -2L;
            long primaryTerm = 0L;
            if (primaryTermField != null && primaryTermField.advanceExact(docId)) {
                boolean found = seqNoField.advanceExact(docId);
                assert (found) : "found seq no for " + docId + " but not a primary term";
                seqNo = seqNoField.longValue();
                primaryTerm = primaryTermField.longValue();
            }
            hit.setSeqNo(seqNo);
            hit.setPrimaryTerm(primaryTerm);
        }
    }
}

