/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.bucketmetrics;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.MultiBucketAggregationBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.BucketMetricsParser;

public abstract class BucketMetricsPipelineAggregationBuilder<AF extends BucketMetricsPipelineAggregationBuilder<AF>>
extends AbstractPipelineAggregationBuilder<AF> {
    private String format = null;
    private BucketHelpers.GapPolicy gapPolicy = BucketHelpers.GapPolicy.SKIP;

    protected BucketMetricsPipelineAggregationBuilder(String name, String type, String[] bucketsPaths) {
        super(name, type, bucketsPaths);
    }

    protected BucketMetricsPipelineAggregationBuilder(StreamInput in, String type) throws IOException {
        super(in, type);
        this.format = in.readOptionalString();
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
    }

    @Override
    protected final void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.format);
        this.gapPolicy.writeTo(out);
        this.innerWriteTo(out);
    }

    protected abstract void innerWriteTo(StreamOutput var1) throws IOException;

    public AF format(String format) {
        this.format = format;
        return (AF)this;
    }

    public String format() {
        return this.format;
    }

    protected DocValueFormat formatter() {
        if (this.format != null) {
            return new DocValueFormat.Decimal(this.format);
        }
        return DocValueFormat.RAW;
    }

    public AF gapPolicy(BucketHelpers.GapPolicy gapPolicy) {
        this.gapPolicy = gapPolicy;
        return (AF)this;
    }

    public BucketHelpers.GapPolicy gapPolicy() {
        return this.gapPolicy;
    }

    @Override
    protected abstract PipelineAggregator createInternal(Map<String, Object> var1) throws IOException;

    @Override
    public void doValidate(AggregatorFactory<?> parent, Collection<AggregationBuilder> aggBuilders, Collection<PipelineAggregationBuilder> pipelineAggregatorFactories) {
        if (this.bucketsPaths.length != 1) {
            throw new IllegalStateException(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName() + " must contain a single entry for aggregation [" + this.name + "]");
        }
        String firstAgg = this.bucketsPaths[0].split("[>\\.]")[0];
        Optional<AggregationBuilder> aggBuilder = aggBuilders.stream().filter(builder -> builder.getName().equals(firstAgg)).findAny();
        if (aggBuilder.isPresent()) {
            if (!(aggBuilder.get() instanceof MultiBucketAggregationBuilder)) {
                throw new IllegalArgumentException("The first aggregation in " + PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName() + " must be a multi-bucket aggregation for aggregation [" + this.name + "] found :" + aggBuilder.get().getClass().getName() + " for buckets path: " + this.bucketsPaths[0]);
            }
        } else {
            throw new IllegalArgumentException(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName() + " aggregation does not exist for aggregation [" + this.name + "]: " + this.bucketsPaths[0]);
        }
    }

    @Override
    protected final XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.format != null) {
            builder.field(BucketMetricsParser.FORMAT.getPreferredName(), this.format);
        }
        if (this.gapPolicy != null) {
            builder.field(BucketMetricsParser.GAP_POLICY.getPreferredName(), this.gapPolicy.getName());
        }
        this.doXContentBody(builder, params);
        return builder;
    }

    protected abstract XContentBuilder doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    @Override
    protected final int doHashCode() {
        return Objects.hash(new Object[]{this.format, this.gapPolicy, this.innerHashCode()});
    }

    protected abstract int innerHashCode();

    @Override
    protected final boolean doEquals(Object obj) {
        BucketMetricsPipelineAggregationBuilder other = (BucketMetricsPipelineAggregationBuilder)obj;
        return Objects.equals(this.format, other.format) && Objects.equals((Object)this.gapPolicy, (Object)other.gapPolicy) && this.innerEquals(other);
    }

    protected abstract boolean innerEquals(BucketMetricsPipelineAggregationBuilder<AF> var1);
}

