/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.Aggregation;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.metrics.ParsedSingleValueNumericMetricsAggregation;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.SimpleValue;

public class ParsedSimpleValue
extends ParsedSingleValueNumericMetricsAggregation
implements SimpleValue {
    private static final ObjectParser<ParsedSimpleValue, Void> PARSER = new ObjectParser(ParsedSimpleValue.class.getSimpleName(), true, ParsedSimpleValue::new);

    @Override
    public String getType() {
        return "simple_value";
    }

    public static ParsedSimpleValue fromXContent(XContentParser parser, String name) {
        ParsedSimpleValue simpleValue = PARSER.apply(parser, null);
        simpleValue.setName(name);
        return simpleValue;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean hasValue = !Double.isNaN(this.value);
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), hasValue ? Double.valueOf(this.value) : null);
        if (hasValue && this.valueAsString != null) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.valueAsString);
        }
        return builder;
    }

    static {
        ParsedSimpleValue.declareSingleValueFields(PARSER, Double.NaN);
    }
}

