/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.repositories;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ElasticsearchParseException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ResourceNotFoundException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.UUIDs;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.repositories.IndexId;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.snapshots.SnapshotId;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.snapshots.SnapshotState;

public final class RepositoryData {
    public static final long EMPTY_REPO_GEN = -1L;
    public static final RepositoryData EMPTY = new RepositoryData(-1L, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList());
    private final long genId;
    private final Map<String, SnapshotId> snapshotIds;
    private final Map<String, SnapshotState> snapshotStates;
    private final Map<String, IndexId> indices;
    private final Map<IndexId, Set<SnapshotId>> indexSnapshots;
    private final List<SnapshotId> incompatibleSnapshotIds;
    private static final String SNAPSHOTS = "snapshots";
    private static final String INCOMPATIBLE_SNAPSHOTS = "incompatible-snapshots";
    private static final String INDICES = "indices";
    private static final String INDEX_ID = "id";
    private static final String NAME = "name";
    private static final String UUID = "uuid";
    private static final String STATE = "state";

    public RepositoryData(long genId, Map<String, SnapshotId> snapshotIds, Map<String, SnapshotState> snapshotStates, Map<IndexId, Set<SnapshotId>> indexSnapshots, List<SnapshotId> incompatibleSnapshotIds) {
        this.genId = genId;
        this.snapshotIds = Collections.unmodifiableMap(snapshotIds);
        this.snapshotStates = Collections.unmodifiableMap(snapshotStates);
        this.indices = Collections.unmodifiableMap(indexSnapshots.keySet().stream().collect(Collectors.toMap(IndexId::getName, Function.identity())));
        this.indexSnapshots = Collections.unmodifiableMap(indexSnapshots);
        this.incompatibleSnapshotIds = Collections.unmodifiableList(incompatibleSnapshotIds);
    }

    protected RepositoryData copy() {
        return new RepositoryData(this.genId, this.snapshotIds, this.snapshotStates, this.indexSnapshots, this.incompatibleSnapshotIds);
    }

    public long getGenId() {
        return this.genId;
    }

    public Collection<SnapshotId> getSnapshotIds() {
        return Collections.unmodifiableCollection(this.snapshotIds.values());
    }

    public Collection<SnapshotId> getIncompatibleSnapshotIds() {
        return this.incompatibleSnapshotIds;
    }

    public Collection<SnapshotId> getAllSnapshotIds() {
        ArrayList<SnapshotId> allSnapshotIds = new ArrayList<SnapshotId>(this.snapshotIds.size() + this.incompatibleSnapshotIds.size());
        allSnapshotIds.addAll(this.snapshotIds.values());
        allSnapshotIds.addAll(this.incompatibleSnapshotIds);
        return Collections.unmodifiableList(allSnapshotIds);
    }

    @Nullable
    public SnapshotState getSnapshotState(SnapshotId snapshotId) {
        return this.snapshotStates.get(snapshotId.getUUID());
    }

    public Map<String, IndexId> getIndices() {
        return this.indices;
    }

    public RepositoryData addSnapshot(SnapshotId snapshotId, SnapshotState snapshotState, List<IndexId> snapshottedIndices) {
        if (this.snapshotIds.containsKey(snapshotId.getUUID())) {
            return this;
        }
        HashMap<String, SnapshotId> snapshots = new HashMap<String, SnapshotId>(this.snapshotIds);
        snapshots.put(snapshotId.getUUID(), snapshotId);
        HashMap<String, SnapshotState> newSnapshotStates = new HashMap<String, SnapshotState>(this.snapshotStates);
        newSnapshotStates.put(snapshotId.getUUID(), snapshotState);
        HashMap<IndexId, Set<SnapshotId>> allIndexSnapshots = new HashMap<IndexId, Set<SnapshotId>>(this.indexSnapshots);
        for (IndexId indexId : snapshottedIndices) {
            Set<SnapshotId> ids;
            if (allIndexSnapshots.containsKey(indexId)) {
                ids = (Set)allIndexSnapshots.get(indexId);
                if (ids == null) {
                    ids = new LinkedHashSet();
                    allIndexSnapshots.put(indexId, ids);
                }
                ids.add(snapshotId);
                continue;
            }
            ids = new LinkedHashSet();
            ids.add(snapshotId);
            allIndexSnapshots.put(indexId, ids);
        }
        return new RepositoryData(this.genId, snapshots, newSnapshotStates, allIndexSnapshots, this.incompatibleSnapshotIds);
    }

    public RepositoryData removeSnapshot(SnapshotId snapshotId) {
        Map<String, SnapshotId> newSnapshotIds = this.snapshotIds.values().stream().filter(id -> !snapshotId.equals(id)).collect(Collectors.toMap(SnapshotId::getUUID, Function.identity()));
        if (newSnapshotIds.size() == this.snapshotIds.size()) {
            throw new ResourceNotFoundException("Attempting to remove non-existent snapshot [{}] from repository data", snapshotId);
        }
        HashMap<String, SnapshotState> newSnapshotStates = new HashMap<String, SnapshotState>(this.snapshotStates);
        newSnapshotStates.remove(snapshotId.getUUID());
        HashMap<IndexId, Set<SnapshotId>> indexSnapshots = new HashMap<IndexId, Set<SnapshotId>>();
        for (IndexId indexId : this.indices.values()) {
            Set<SnapshotId> set;
            Set<SnapshotId> snapshotIds = this.indexSnapshots.get(indexId);
            assert (snapshotIds != null);
            if (snapshotIds.contains(snapshotId)) {
                if (snapshotIds.size() == 1) continue;
                set = new LinkedHashSet<SnapshotId>(snapshotIds);
                set.remove(snapshotId);
            } else {
                set = snapshotIds;
            }
            indexSnapshots.put(indexId, set);
        }
        return new RepositoryData(this.genId, newSnapshotIds, newSnapshotStates, indexSnapshots, this.incompatibleSnapshotIds);
    }

    public Set<SnapshotId> getSnapshots(IndexId indexId) {
        Set<SnapshotId> snapshotIds = this.indexSnapshots.get(indexId);
        if (snapshotIds == null) {
            throw new IllegalArgumentException("unknown snapshot index " + indexId);
        }
        return snapshotIds;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryData that = (RepositoryData)obj;
        return this.snapshotIds.equals(that.snapshotIds) && this.snapshotStates.equals(that.snapshotStates) && this.indices.equals(that.indices) && this.indexSnapshots.equals(that.indexSnapshots) && this.incompatibleSnapshotIds.equals(that.incompatibleSnapshotIds);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotIds, this.snapshotStates, this.indices, this.indexSnapshots, this.incompatibleSnapshotIds);
    }

    public IndexId resolveIndexId(String indexName) {
        if (this.indices.containsKey(indexName)) {
            return this.indices.get(indexName);
        }
        return new IndexId(indexName, indexName);
    }

    public List<IndexId> resolveIndices(List<String> indices) {
        ArrayList<IndexId> resolvedIndices = new ArrayList<IndexId>(indices.size());
        for (String indexName : indices) {
            resolvedIndices.add(this.resolveIndexId(indexName));
        }
        return resolvedIndices;
    }

    public List<IndexId> resolveNewIndices(List<String> indicesToResolve) {
        ArrayList<IndexId> snapshotIndices = new ArrayList<IndexId>();
        for (String index : indicesToResolve) {
            IndexId indexId = this.indices.containsKey(index) ? this.indices.get(index) : new IndexId(index, UUIDs.randomBase64UUID());
            snapshotIndices.add(indexId);
        }
        return snapshotIndices;
    }

    public XContentBuilder snapshotsToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(SNAPSHOTS);
        for (SnapshotId snapshot : this.getSnapshotIds()) {
            builder.startObject();
            builder.field(NAME, snapshot.getName());
            builder.field(UUID, snapshot.getUUID());
            if (this.snapshotStates.containsKey(snapshot.getUUID())) {
                builder.field(STATE, this.snapshotStates.get(snapshot.getUUID()).value());
            }
            builder.endObject();
        }
        builder.endArray();
        builder.startObject(INDICES);
        for (IndexId indexId : this.getIndices().values()) {
            builder.startObject(indexId.getName());
            builder.field(INDEX_ID, indexId.getId());
            builder.startArray(SNAPSHOTS);
            Set<SnapshotId> snapshotIds = this.indexSnapshots.get(indexId);
            assert (snapshotIds != null);
            for (SnapshotId snapshotId : snapshotIds) {
                builder.value(snapshotId.getUUID());
            }
            builder.endArray();
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static RepositoryData snapshotsFromXContent(XContentParser parser, long genId) throws IOException {
        HashMap<String, SnapshotId> snapshots = new HashMap<String, SnapshotId>();
        HashMap<String, SnapshotState> snapshotStates = new HashMap<String, SnapshotState>();
        HashMap<IndexId, Set<SnapshotId>> indexSnapshots = new HashMap<IndexId, Set<SnapshotId>>();
        if (parser.nextToken() == XContentParser.Token.START_OBJECT) {
            while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                String field = parser.currentName();
                if (SNAPSHOTS.equals(field)) {
                    if (parser.nextToken() == XContentParser.Token.START_ARRAY) {
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            SnapshotId snapshotId;
                            String name;
                            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                                name = null;
                                String uuid = null;
                                SnapshotState state = null;
                                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                                    String currentFieldName = parser.currentName();
                                    parser.nextToken();
                                    if (NAME.equals(currentFieldName)) {
                                        name = parser.text();
                                        continue;
                                    }
                                    if (UUID.equals(currentFieldName)) {
                                        uuid = parser.text();
                                        continue;
                                    }
                                    if (!STATE.equals(currentFieldName)) continue;
                                    state = SnapshotState.fromValue(parser.numberValue().byteValue());
                                }
                                snapshotId = new SnapshotId(name, uuid);
                                if (state != null) {
                                    snapshotStates.put(uuid, state);
                                }
                            } else {
                                name = parser.text();
                                snapshotId = new SnapshotId(name, name);
                            }
                            snapshots.put(snapshotId.getUUID(), snapshotId);
                        }
                        continue;
                    }
                    throw new ElasticsearchParseException("expected array for [" + field + "]", new Object[0]);
                }
                if (INDICES.equals(field)) {
                    if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                        throw new ElasticsearchParseException("start object expected [indices]", new Object[0]);
                    }
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String indexName = parser.currentName();
                        LinkedHashSet<SnapshotId> snapshotIds = new LinkedHashSet<SnapshotId>();
                        IndexId indexId = null;
                        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                            throw new ElasticsearchParseException("start object expected index[" + indexName + "]", new Object[0]);
                        }
                        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                            String indexMetaFieldName = parser.currentName();
                            parser.nextToken();
                            if (INDEX_ID.equals(indexMetaFieldName)) {
                                indexId = new IndexId(indexName, parser.text());
                                continue;
                            }
                            if (!SNAPSHOTS.equals(indexMetaFieldName)) continue;
                            if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
                                throw new ElasticsearchParseException("start array expected [snapshots]", new Object[0]);
                            }
                            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                SnapshotId snapshotId;
                                String uuid = null;
                                if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                                        String currentFieldName = parser.currentName();
                                        parser.nextToken();
                                        if (!UUID.equals(currentFieldName)) continue;
                                        uuid = parser.text();
                                    }
                                } else {
                                    uuid = parser.text();
                                }
                                if ((snapshotId = (SnapshotId)snapshots.get(uuid)) != null) {
                                    snapshotIds.add(snapshotId);
                                    continue;
                                }
                                throw new ElasticsearchParseException("Detected a corrupted repository, index " + indexId + " references an unknown snapshot uuid [" + uuid + "]", new Object[0]);
                            }
                        }
                        assert (indexId != null);
                        indexSnapshots.put(indexId, snapshotIds);
                    }
                    continue;
                }
                throw new ElasticsearchParseException("unknown field name  [" + field + "]", new Object[0]);
            }
        } else {
            throw new ElasticsearchParseException("start object expected", new Object[0]);
        }
        return new RepositoryData(genId, snapshots, snapshotStates, indexSnapshots, Collections.emptyList());
    }

    public XContentBuilder incompatibleSnapshotsToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(INCOMPATIBLE_SNAPSHOTS);
        for (SnapshotId snapshot : this.getIncompatibleSnapshotIds()) {
            snapshot.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public RepositoryData incompatibleSnapshotsFromXContent(XContentParser parser) throws IOException {
        ArrayList<SnapshotId> incompatibleSnapshotIds = new ArrayList<SnapshotId>();
        if (parser.nextToken() == XContentParser.Token.START_OBJECT) {
            while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                String currentFieldName = parser.currentName();
                if (INCOMPATIBLE_SNAPSHOTS.equals(currentFieldName)) {
                    if (parser.nextToken() == XContentParser.Token.START_ARRAY) {
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            incompatibleSnapshotIds.add(SnapshotId.fromXContent(parser));
                        }
                        continue;
                    }
                    throw new ElasticsearchParseException("expected array for [" + currentFieldName + "]", new Object[0]);
                }
                throw new ElasticsearchParseException("unknown field name  [" + currentFieldName + "]", new Object[0]);
            }
        } else {
            throw new ElasticsearchParseException("start object expected", new Object[0]);
        }
        return new RepositoryData(this.genId, this.snapshotIds, this.snapshotStates, this.indexSnapshots, incompatibleSnapshotIds);
    }
}

