/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.join.BitSetProducer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.similarities.Similarity;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.SetOnce;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.Client;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.CheckedFunction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParsingException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lucene.search.Queries;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.Index;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.IndexAnalyzers;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.IndexFieldData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.ContentPath;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.DocumentMapper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.Mapper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MapperService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.ObjectMapper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.TextFieldMapper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.AbstractQueryBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.ParsedQuery;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.QueryBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.QueryRewriteContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.QueryShardException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.Rewriteable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.support.NestedScope;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.similarity.SimilarityService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.ScriptService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.lookup.SearchLookup;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.RemoteClusterAware;

public class QueryShardContext
extends QueryRewriteContext {
    private final ScriptService scriptService;
    private final IndexSettings indexSettings;
    private final MapperService mapperService;
    private final SimilarityService similarityService;
    private final BitsetFilterCache bitsetFilterCache;
    private final Function<IndexReaderContext, IndexSearcher> searcherFactory;
    private final BiFunction<MappedFieldType, String, IndexFieldData<?>> indexFieldDataService;
    private final int shardId;
    private final IndexReader reader;
    private final String clusterAlias;
    private String[] types = Strings.EMPTY_ARRAY;
    private boolean cacheable = true;
    private final SetOnce<Boolean> frozen = new SetOnce();
    private final Index fullyQualifiedIndex;
    private final Map<String, Query> namedQueries = new HashMap<String, Query>();
    private boolean allowUnmappedFields;
    private boolean mapUnmappedFieldAsString;
    private NestedScope nestedScope;
    private boolean isFilter;
    private SearchLookup lookup = null;

    public void setTypes(String ... types) {
        this.types = types;
    }

    public String[] getTypes() {
        return this.types;
    }

    public QueryShardContext(int shardId, IndexSettings indexSettings, BitsetFilterCache bitsetFilterCache, Function<IndexReaderContext, IndexSearcher> searcherFactory, BiFunction<MappedFieldType, String, IndexFieldData<?>> indexFieldDataLookup, MapperService mapperService, SimilarityService similarityService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, NamedWriteableRegistry namedWriteableRegistry, Client client, IndexReader reader, LongSupplier nowInMillis, String clusterAlias) {
        super(xContentRegistry, namedWriteableRegistry, client, nowInMillis);
        this.shardId = shardId;
        this.similarityService = similarityService;
        this.mapperService = mapperService;
        this.bitsetFilterCache = bitsetFilterCache;
        this.searcherFactory = searcherFactory;
        this.indexFieldDataService = indexFieldDataLookup;
        this.allowUnmappedFields = indexSettings.isDefaultAllowUnmappedFields();
        this.nestedScope = new NestedScope();
        this.scriptService = scriptService;
        this.indexSettings = indexSettings;
        this.reader = reader;
        this.clusterAlias = clusterAlias;
        this.fullyQualifiedIndex = new Index(RemoteClusterAware.buildRemoteIndexName(clusterAlias, indexSettings.getIndex().getName()), indexSettings.getIndex().getUUID());
    }

    public QueryShardContext(QueryShardContext source) {
        this(source.shardId, source.indexSettings, source.bitsetFilterCache, source.searcherFactory, source.indexFieldDataService, source.mapperService, source.similarityService, source.scriptService, source.getXContentRegistry(), source.getWriteableRegistry(), source.client, source.reader, source.nowInMillis, source.clusterAlias);
        this.types = source.getTypes();
    }

    private void reset() {
        this.allowUnmappedFields = this.indexSettings.isDefaultAllowUnmappedFields();
        this.lookup = null;
        this.namedQueries.clear();
        this.nestedScope = new NestedScope();
        this.isFilter = false;
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.mapperService.getIndexAnalyzers();
    }

    public Similarity getSearchSimilarity() {
        return this.similarityService != null ? this.similarityService.similarity(this.mapperService) : null;
    }

    public List<String> defaultFields() {
        return this.indexSettings.getDefaultFields();
    }

    public boolean queryStringLenient() {
        return this.indexSettings.isQueryStringLenient();
    }

    public boolean queryStringAnalyzeWildcard() {
        return this.indexSettings.isQueryStringAnalyzeWildcard();
    }

    public boolean queryStringAllowLeadingWildcard() {
        return this.indexSettings.isQueryStringAllowLeadingWildcard();
    }

    public BitSetProducer bitsetFilter(Query filter) {
        return this.bitsetFilterCache.getBitSetProducer(filter);
    }

    public IndexSearcher newCachedSearcher(IndexReaderContext context) {
        return this.searcherFactory.apply(context);
    }

    public <IFD extends IndexFieldData<?>> IFD getForField(MappedFieldType fieldType) {
        return (IFD)this.indexFieldDataService.apply(fieldType, this.fullyQualifiedIndex.getName());
    }

    public void addNamedQuery(String name, Query query) {
        if (query != null) {
            this.namedQueries.put(name, query);
        }
    }

    public Map<String, Query> copyNamedQueries() {
        return Collections.unmodifiableMap(new HashMap<String, Query>(this.namedQueries));
    }

    @Deprecated
    public boolean isFilter() {
        return this.isFilter;
    }

    public void setIsFilter(boolean isFilter) {
        this.isFilter = isFilter;
    }

    public Collection<String> simpleMatchToIndexNames(String pattern) {
        return this.mapperService.simpleMatchToFullName(pattern);
    }

    public MappedFieldType fieldMapper(String name) {
        return this.failIfFieldMappingNotFound(name, this.mapperService.fullName(name));
    }

    public ObjectMapper getObjectMapper(String name) {
        return this.mapperService.getObjectMapper(name);
    }

    public DocumentMapper documentMapper(String type) {
        return this.mapperService.documentMapper(type);
    }

    public Analyzer getSearchAnalyzer(MappedFieldType fieldType) {
        if (fieldType.searchAnalyzer() != null) {
            return fieldType.searchAnalyzer();
        }
        return this.getMapperService().searchAnalyzer();
    }

    public Analyzer getSearchQuoteAnalyzer(MappedFieldType fieldType) {
        if (fieldType.searchQuoteAnalyzer() != null) {
            return fieldType.searchQuoteAnalyzer();
        }
        return this.getMapperService().searchQuoteAnalyzer();
    }

    public void setAllowUnmappedFields(boolean allowUnmappedFields) {
        this.allowUnmappedFields = allowUnmappedFields;
    }

    public void setMapUnmappedFieldAsString(boolean mapUnmappedFieldAsString) {
        this.mapUnmappedFieldAsString = mapUnmappedFieldAsString;
    }

    MappedFieldType failIfFieldMappingNotFound(String name, MappedFieldType fieldMapping) {
        if (fieldMapping != null || this.allowUnmappedFields) {
            return fieldMapping;
        }
        if (this.mapUnmappedFieldAsString) {
            TextFieldMapper.Builder builder = new TextFieldMapper.Builder(name);
            return builder.build(new Mapper.BuilderContext(this.indexSettings.getSettings(), new ContentPath(1))).fieldType();
        }
        throw new QueryShardException(this, "No field mapping can be found for the field with name [{}]", name);
    }

    public Collection<String> queryTypes() {
        String[] types = this.getTypes();
        if (types == null || types.length == 0) {
            return this.getMapperService().types();
        }
        if (types.length == 1 && types[0].equals("_all")) {
            return this.getMapperService().types();
        }
        return Arrays.asList(types);
    }

    public SearchLookup lookup() {
        if (this.lookup == null) {
            this.lookup = new SearchLookup(this.getMapperService(), mappedFieldType -> this.indexFieldDataService.apply((MappedFieldType)mappedFieldType, this.fullyQualifiedIndex.getName()), this.types);
        }
        return this.lookup;
    }

    public NestedScope nestedScope() {
        return this.nestedScope;
    }

    public Version indexVersionCreated() {
        return this.indexSettings.getIndexVersionCreated();
    }

    public ParsedQuery toFilter(QueryBuilder queryBuilder) {
        return this.toQuery(queryBuilder, q -> {
            Query filter = q.toFilter(this);
            if (filter == null) {
                return null;
            }
            return filter;
        });
    }

    public ParsedQuery toQuery(QueryBuilder queryBuilder) {
        return this.toQuery(queryBuilder, q -> {
            Query query = q.toQuery(this);
            if (query == null) {
                query = Queries.newMatchNoDocsQuery("No query left after rewrite.");
            }
            return query;
        });
    }

    private ParsedQuery toQuery(QueryBuilder queryBuilder, CheckedFunction<QueryBuilder, Query, IOException> filterOrQuery) {
        this.reset();
        try {
            QueryBuilder rewriteQuery = Rewriteable.rewrite(queryBuilder, this, true);
            ParsedQuery parsedQuery = new ParsedQuery(filterOrQuery.apply(rewriteQuery), this.copyNamedQueries());
            return parsedQuery;
        }
        catch (ParsingException | QueryShardException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryShardException(this, "failed to create query: {}", (Throwable)e, queryBuilder);
        }
        finally {
            this.reset();
        }
    }

    public Index index() {
        return this.indexSettings.getIndex();
    }

    public final ScriptService getScriptService() {
        this.failIfFrozen();
        return this.scriptService;
    }

    public final void freezeContext() {
        this.frozen.set(Boolean.TRUE);
    }

    protected final void failIfFrozen() {
        this.cacheable = false;
        if (this.frozen.get() == Boolean.TRUE) {
            throw new IllegalArgumentException("features that prevent cachability are disabled on this context");
        }
        assert (this.frozen.get() == null) : this.frozen.get();
    }

    @Override
    public void registerAsyncAction(BiConsumer<Client, ActionListener<?>> asyncAction) {
        this.failIfFrozen();
        super.registerAsyncAction(asyncAction);
    }

    @Override
    public void executeAsyncActions(ActionListener listener) {
        this.failIfFrozen();
        super.executeAsyncActions(listener);
    }

    public final boolean isCacheable() {
        return this.cacheable;
    }

    public int getShardId() {
        return this.shardId;
    }

    @Override
    public final long nowInMillis() {
        this.failIfFrozen();
        return super.nowInMillis();
    }

    public Client getClient() {
        this.failIfFrozen();
        return this.client;
    }

    public QueryBuilder parseInnerQueryBuilder(XContentParser parser) throws IOException {
        return AbstractQueryBuilder.parseInnerQueryBuilder(parser);
    }

    @Override
    public final QueryShardContext convertToShardContext() {
        return this;
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public MapperService getMapperService() {
        return this.mapperService;
    }

    public IndexReader getIndexReader() {
        return this.reader;
    }

    public Index getFullyQualifiedIndex() {
        return this.fullyQualifiedIndex;
    }
}

