/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.AbstractQueryBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.InnerHitBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.ParsedQuery;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.QueryBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.SearchScript;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.subphase.DocValueFieldsContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.subphase.InnerHitsContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.subphase.ScriptFieldsContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.internal.SearchContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.sort.SortAndFormats;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.sort.SortBuilder;

public abstract class InnerHitContextBuilder {
    protected final QueryBuilder query;
    protected final InnerHitBuilder innerHitBuilder;
    protected final Map<String, InnerHitContextBuilder> children;

    protected InnerHitContextBuilder(QueryBuilder query, InnerHitBuilder innerHitBuilder, Map<String, InnerHitContextBuilder> children) {
        this.innerHitBuilder = innerHitBuilder;
        this.children = children;
        this.query = query;
    }

    public final void build(SearchContext parentSearchContext, InnerHitsContext innerHitsContext) throws IOException {
        int maxInnerResultWindow;
        long innerResultWindow = this.innerHitBuilder.getFrom() + this.innerHitBuilder.getSize();
        if (innerResultWindow > (long)(maxInnerResultWindow = parentSearchContext.mapperService().getIndexSettings().getMaxInnerResultWindow())) {
            throw new IllegalArgumentException("Inner result window is too large, the inner hit definition's [" + this.innerHitBuilder.getName() + "]'s from + size must be less than or equal to: [" + maxInnerResultWindow + "] but was [" + innerResultWindow + "]. This limit can be set by changing the [" + IndexSettings.MAX_INNER_RESULT_WINDOW_SETTING.getKey() + "] index level setting.");
        }
        this.doBuild(parentSearchContext, innerHitsContext);
    }

    protected abstract void doBuild(SearchContext var1, InnerHitsContext var2) throws IOException;

    public static void extractInnerHits(QueryBuilder query, Map<String, InnerHitContextBuilder> innerHitBuilders) {
        if (!(query instanceof AbstractQueryBuilder)) {
            throw new IllegalStateException("provided query builder [" + query.getClass() + "] class should inherit from AbstractQueryBuilder, but it doesn't");
        }
        ((AbstractQueryBuilder)query).extractInnerHitBuilders(innerHitBuilders);
    }

    protected void setupInnerHitsContext(QueryShardContext queryShardContext, InnerHitsContext.InnerHitSubContext innerHitsContext) throws IOException {
        Optional<SortAndFormats> optionalSort;
        innerHitsContext.from(this.innerHitBuilder.getFrom());
        innerHitsContext.size(this.innerHitBuilder.getSize());
        innerHitsContext.explain(this.innerHitBuilder.isExplain());
        innerHitsContext.version(this.innerHitBuilder.isVersion());
        innerHitsContext.seqNoAndPrimaryTerm(this.innerHitBuilder.isSeqNoAndPrimaryTerm());
        innerHitsContext.trackScores(this.innerHitBuilder.isTrackScores());
        if (this.innerHitBuilder.getStoredFieldsContext() != null) {
            innerHitsContext.storedFieldsContext(this.innerHitBuilder.getStoredFieldsContext());
        }
        if (this.innerHitBuilder.getDocValueFields() != null) {
            innerHitsContext.docValueFieldsContext(new DocValueFieldsContext(this.innerHitBuilder.getDocValueFields()));
        }
        if (this.innerHitBuilder.getScriptFields() != null) {
            for (SearchSourceBuilder.ScriptField field : this.innerHitBuilder.getScriptFields()) {
                QueryShardContext innerContext = innerHitsContext.getQueryShardContext();
                SearchScript.Factory factory = innerContext.getScriptService().compile(field.script(), SearchScript.CONTEXT);
                SearchScript.LeafFactory searchScript = factory.newFactory(field.script().getParams(), innerHitsContext.lookup());
                innerHitsContext.scriptFields().add(new ScriptFieldsContext.ScriptField(field.fieldName(), searchScript, field.ignoreFailure()));
            }
        }
        if (this.innerHitBuilder.getFetchSourceContext() != null) {
            innerHitsContext.fetchSourceContext(this.innerHitBuilder.getFetchSourceContext());
        }
        if (this.innerHitBuilder.getSorts() != null && (optionalSort = SortBuilder.buildSort(this.innerHitBuilder.getSorts(), queryShardContext)).isPresent()) {
            innerHitsContext.sort(optionalSort.get());
        }
        if (this.innerHitBuilder.getHighlightBuilder() != null) {
            innerHitsContext.highlight(this.innerHitBuilder.getHighlightBuilder().build(queryShardContext));
        }
        ParsedQuery parsedQuery = new ParsedQuery(this.query.toQuery(queryShardContext), queryShardContext.copyNamedQueries());
        innerHitsContext.parsedQuery(parsedQuery);
        Map<String, InnerHitsContext.InnerHitSubContext> baseChildren = InnerHitContextBuilder.buildChildInnerHits(innerHitsContext.parentSearchContext(), this.children);
        innerHitsContext.setChildInnerHits(baseChildren);
    }

    private static Map<String, InnerHitsContext.InnerHitSubContext> buildChildInnerHits(SearchContext parentSearchContext, Map<String, InnerHitContextBuilder> children) throws IOException {
        HashMap<String, InnerHitsContext.InnerHitSubContext> childrenInnerHits = new HashMap<String, InnerHitsContext.InnerHitSubContext>();
        for (Map.Entry<String, InnerHitContextBuilder> entry : children.entrySet()) {
            InnerHitsContext childInnerHitsContext = new InnerHitsContext();
            entry.getValue().build(parentSearchContext, childInnerHitsContext);
            if (childInnerHitsContext.getInnerHits() == null) continue;
            childrenInnerHits.putAll(childInnerHitsContext.getInnerHits());
        }
        return childrenInnerHits;
    }
}

