/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexableField;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.MultiTermQuery;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lucene.Lucene;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lucene.search.Queries;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.regex.Regex;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.IndexFieldData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.plain.ConstantIndexFieldData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.Mapper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MapperParsingException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.ParseContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.QueryShardContext;

public class IndexFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_index";
    public static final String CONTENT_TYPE = "_index";

    private IndexFieldMapper(Settings indexSettings, MappedFieldType existing) {
        this(existing == null ? Defaults.FIELD_TYPE.clone() : existing, indexSettings);
    }

    private IndexFieldMapper(MappedFieldType fieldType, Settings indexSettings) {
        super("_index", fieldType, Defaults.FIELD_TYPE, indexSettings);
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
    }

    @Override
    protected String contentType() {
        return "_index";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
    }

    static final class IndexFieldType
    extends MappedFieldType {
        IndexFieldType() {
        }

        protected IndexFieldType(IndexFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new IndexFieldType(this);
        }

        @Override
        public String typeName() {
            return "_index";
        }

        @Override
        public boolean isSearchable() {
            return true;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new MatchAllDocsQuery();
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryShardContext context) {
            if (this.isSameIndex(value, context.getFullyQualifiedIndex().getName())) {
                return Queries.newMatchAllQuery();
            }
            return Queries.newMatchNoDocsQuery("Index didn't match. Index queried: " + context.index().getName() + " vs. " + value);
        }

        public Query termsQuery(List values, QueryShardContext context) {
            if (context == null) {
                return super.termsQuery(values, context);
            }
            for (Object value : values) {
                if (!this.isSameIndex(value, context.getFullyQualifiedIndex().getName())) continue;
                return Queries.newMatchAllQuery();
            }
            return Queries.newMatchNoDocsQuery("Index didn't match. Index queried: " + context.getFullyQualifiedIndex().getName() + " vs. " + values);
        }

        @Override
        public Query prefixQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            String indexName = context.getFullyQualifiedIndex().getName();
            if (indexName.startsWith(value)) {
                return Queries.newMatchAllQuery();
            }
            return Queries.newMatchNoDocsQuery("The index [" + indexName + "] doesn't match the provided prefix [" + value + "].");
        }

        @Override
        public Query regexpQuery(String value, int flags, int maxDeterminizedStates, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            String indexName = context.getFullyQualifiedIndex().getName();
            Pattern pattern = Regex.compile(value, Regex.flagsToString(flags));
            if (pattern.matcher(indexName).matches()) {
                return Queries.newMatchAllQuery();
            }
            return Queries.newMatchNoDocsQuery("The index [" + indexName + "] doesn't match the provided pattern [" + value + "].");
        }

        @Override
        public Query wildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            String indexName = context.getFullyQualifiedIndex().getName();
            if (this.isSameIndex(value, indexName)) {
                return Queries.newMatchAllQuery();
            }
            return Queries.newMatchNoDocsQuery("The index [" + indexName + "] doesn't match the provided pattern [" + value + "].");
        }

        private boolean isSameIndex(Object value, String indexName) {
            String pattern = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            return Regex.simpleMatch(pattern, indexName);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            return new ConstantIndexFieldData.Builder(mapperService -> fullyQualifiedIndexName);
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        @Override
        public MetadataFieldMapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            if (parserContext.indexVersionCreated().onOrAfter(Version.V_5_0_0_alpha3)) {
                throw new MapperParsingException("_index is not configurable");
            }
            return new Builder(parserContext.mapperService().fullName("_index"));
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            Settings indexSettings = context.mapperService().getIndexSettings().getSettings();
            return new IndexFieldMapper(indexSettings, fieldType);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, IndexFieldMapper> {
        public Builder(MappedFieldType existing) {
            super("_index", existing == null ? Defaults.FIELD_TYPE : existing, Defaults.FIELD_TYPE);
        }

        @Override
        public IndexFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new IndexFieldMapper(this.fieldType, context.indexSettings());
        }
    }

    public static class Defaults {
        public static final String NAME = "_index";
        public static final MappedFieldType FIELD_TYPE = new IndexFieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setName("_index");
            FIELD_TYPE.freeze();
        }
    }
}

