/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.synonym.WordnetSynonymParser;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.CharsRef;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.CharsRefBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ESWordnetSynonymParser
extends WordnetSynonymParser {
    private static final Logger logger = LogManager.getLogger(ESWordnetSynonymParser.class);
    private final boolean lenient;

    public ESWordnetSynonymParser(boolean dedup, boolean expand, boolean lenient, Analyzer analyzer) {
        super(dedup, expand, analyzer);
        this.lenient = lenient;
    }

    @Override
    public void add(CharsRef input, CharsRef output, boolean includeOrig) {
        if (!this.lenient || input.length > 0 && output.length > 0) {
            super.add(input, output, includeOrig);
        }
    }

    @Override
    public CharsRef analyze(String text, CharsRefBuilder reuse) throws IOException {
        try {
            return super.analyze(text, reuse);
        }
        catch (IllegalArgumentException ex) {
            if (this.lenient) {
                logger.info("Synonym rule for [" + text + "] was ignored");
                return new CharsRef("");
            }
            throw ex;
        }
    }
}

