/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.support;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Booleans;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.DeprecationHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParseException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;

public abstract class AbstractXContentParser
implements XContentParser {
    public static final boolean DEFAULT_NUMBER_COERCE_POLICY = true;
    private final NamedXContentRegistry xContentRegistry;
    private final DeprecationHandler deprecationHandler;
    private static BigInteger LONG_MAX_VALUE_AS_BIGINTEGER = BigInteger.valueOf(Long.MAX_VALUE);
    private static BigInteger LONG_MIN_VALUE_AS_BIGINTEGER = BigInteger.valueOf(Long.MIN_VALUE);
    private static BigDecimal BIGDECIMAL_GREATER_THAN_LONG_MAX_VALUE = BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.ONE);
    private static BigDecimal BIGDECIMAL_LESS_THAN_LONG_MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.ONE);
    static final MapFactory SIMPLE_MAP_FACTORY = HashMap::new;
    static final MapFactory ORDERED_MAP_FACTORY = LinkedHashMap::new;
    static final MapStringsFactory SIMPLE_MAP_STRINGS_FACTORY = HashMap::new;
    static final MapStringsFactory ORDERED_MAP_STRINGS_FACTORY = LinkedHashMap::new;

    private static void checkCoerceString(boolean coerce, Class<? extends Number> clazz) {
        if (!coerce) {
            throw new IllegalArgumentException(clazz.getSimpleName() + " value passed as String");
        }
    }

    public AbstractXContentParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler) {
        this.xContentRegistry = xContentRegistry;
        this.deprecationHandler = deprecationHandler;
    }

    void ensureNumberConversion(boolean coerce, long result, Class<? extends Number> clazz) throws IOException {
        double fullVal;
        if (!coerce && (double)result != (fullVal = this.doDoubleValue())) {
            throw new IllegalArgumentException(fullVal + " cannot be converted to " + clazz.getSimpleName() + " without data loss");
        }
    }

    @Override
    public boolean isBooleanValue() throws IOException {
        switch (this.currentToken()) {
            case VALUE_BOOLEAN: {
                return true;
            }
            case VALUE_STRING: {
                return Booleans.isBoolean(this.textCharacters(), this.textOffset(), this.textLength());
            }
        }
        return false;
    }

    @Override
    public boolean booleanValue() throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            return Booleans.parseBoolean(this.textCharacters(), this.textOffset(), this.textLength(), false);
        }
        return this.doBooleanValue();
    }

    @Override
    @Deprecated
    public boolean isBooleanValueLenient() throws IOException {
        switch (this.currentToken()) {
            case VALUE_BOOLEAN: {
                return true;
            }
            case VALUE_NUMBER: {
                XContentParser.NumberType numberType = this.numberType();
                return numberType == XContentParser.NumberType.LONG || numberType == XContentParser.NumberType.INT;
            }
            case VALUE_STRING: {
                return Booleans.isBooleanLenient(this.textCharacters(), this.textOffset(), this.textLength());
            }
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean booleanValueLenient() throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_NUMBER) {
            return this.intValue() != 0;
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            return Booleans.parseBooleanLenient(this.textCharacters(), this.textOffset(), this.textLength(), false);
        }
        return this.doBooleanValue();
    }

    protected abstract boolean doBooleanValue() throws IOException;

    @Override
    public short shortValue() throws IOException {
        return this.shortValue(true);
    }

    @Override
    public short shortValue(boolean coerce) throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            AbstractXContentParser.checkCoerceString(coerce, Short.class);
            double doubleValue = Double.parseDouble(this.text());
            if (doubleValue < -32768.0 || doubleValue > 32767.0) {
                throw new IllegalArgumentException("Value [" + this.text() + "] is out of range for a short");
            }
            return (short)doubleValue;
        }
        short result = this.doShortValue();
        this.ensureNumberConversion(coerce, result, Short.class);
        return result;
    }

    protected abstract short doShortValue() throws IOException;

    @Override
    public int intValue() throws IOException {
        return this.intValue(true);
    }

    @Override
    public int intValue(boolean coerce) throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            AbstractXContentParser.checkCoerceString(coerce, Integer.class);
            double doubleValue = Double.parseDouble(this.text());
            if (doubleValue < -2.147483648E9 || doubleValue > 2.147483647E9) {
                throw new IllegalArgumentException("Value [" + this.text() + "] is out of range for an integer");
            }
            return (int)doubleValue;
        }
        int result = this.doIntValue();
        this.ensureNumberConversion(coerce, result, Integer.class);
        return result;
    }

    protected abstract int doIntValue() throws IOException;

    private static long toLong(String stringValue, boolean coerce) {
        try {
            return Long.parseLong(stringValue);
        }
        catch (NumberFormatException numberFormatException) {
            BigInteger bigIntegerValue;
            try {
                BigDecimal bigDecimalValue = new BigDecimal(stringValue);
                if (bigDecimalValue.compareTo(BIGDECIMAL_GREATER_THAN_LONG_MAX_VALUE) >= 0 || bigDecimalValue.compareTo(BIGDECIMAL_LESS_THAN_LONG_MIN_VALUE) <= 0) {
                    throw new IllegalArgumentException("Value [" + stringValue + "] is out of range for a long");
                }
                bigIntegerValue = coerce ? bigDecimalValue.toBigInteger() : bigDecimalValue.toBigIntegerExact();
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException("Value [" + stringValue + "] has a decimal part");
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("For input string: \"" + stringValue + "\"");
            }
            if (bigIntegerValue.compareTo(LONG_MAX_VALUE_AS_BIGINTEGER) > 0 || bigIntegerValue.compareTo(LONG_MIN_VALUE_AS_BIGINTEGER) < 0) {
                throw new IllegalArgumentException("Value [" + stringValue + "] is out of range for a long");
            }
            assert (bigIntegerValue.longValueExact() <= Long.MAX_VALUE);
            return bigIntegerValue.longValue();
        }
    }

    @Override
    public long longValue() throws IOException {
        return this.longValue(true);
    }

    @Override
    public long longValue(boolean coerce) throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            AbstractXContentParser.checkCoerceString(coerce, Long.class);
            return AbstractXContentParser.toLong(this.text(), coerce);
        }
        long result = this.doLongValue();
        this.ensureNumberConversion(coerce, result, Long.class);
        return result;
    }

    protected abstract long doLongValue() throws IOException;

    @Override
    public float floatValue() throws IOException {
        return this.floatValue(true);
    }

    @Override
    public float floatValue(boolean coerce) throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            AbstractXContentParser.checkCoerceString(coerce, Float.class);
            return Float.parseFloat(this.text());
        }
        return this.doFloatValue();
    }

    protected abstract float doFloatValue() throws IOException;

    @Override
    public double doubleValue() throws IOException {
        return this.doubleValue(true);
    }

    @Override
    public double doubleValue(boolean coerce) throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            AbstractXContentParser.checkCoerceString(coerce, Double.class);
            return Double.parseDouble(this.text());
        }
        return this.doDoubleValue();
    }

    protected abstract double doDoubleValue() throws IOException;

    @Override
    public final String textOrNull() throws IOException {
        if (this.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        return this.text();
    }

    @Override
    public CharBuffer charBufferOrNull() throws IOException {
        if (this.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        return this.charBuffer();
    }

    @Override
    public Map<String, Object> map() throws IOException {
        return AbstractXContentParser.readMap(this);
    }

    @Override
    public Map<String, Object> mapOrdered() throws IOException {
        return AbstractXContentParser.readOrderedMap(this);
    }

    @Override
    public Map<String, String> mapStrings() throws IOException {
        return AbstractXContentParser.readMapStrings(this);
    }

    @Override
    public Map<String, String> mapStringsOrdered() throws IOException {
        return AbstractXContentParser.readOrderedMapStrings(this);
    }

    @Override
    public List<Object> list() throws IOException {
        return AbstractXContentParser.readList(this);
    }

    @Override
    public List<Object> listOrderedMap() throws IOException {
        return AbstractXContentParser.readListOrderedMap(this);
    }

    static Map<String, Object> readMap(XContentParser parser) throws IOException {
        return AbstractXContentParser.readMap(parser, SIMPLE_MAP_FACTORY);
    }

    static Map<String, Object> readOrderedMap(XContentParser parser) throws IOException {
        return AbstractXContentParser.readMap(parser, ORDERED_MAP_FACTORY);
    }

    static Map<String, String> readMapStrings(XContentParser parser) throws IOException {
        return AbstractXContentParser.readMapStrings(parser, SIMPLE_MAP_STRINGS_FACTORY);
    }

    static Map<String, String> readOrderedMapStrings(XContentParser parser) throws IOException {
        return AbstractXContentParser.readMapStrings(parser, ORDERED_MAP_STRINGS_FACTORY);
    }

    static List<Object> readList(XContentParser parser) throws IOException {
        return AbstractXContentParser.readList(parser, SIMPLE_MAP_FACTORY);
    }

    static List<Object> readListOrderedMap(XContentParser parser) throws IOException {
        return AbstractXContentParser.readList(parser, ORDERED_MAP_FACTORY);
    }

    static Map<String, Object> readMap(XContentParser parser, MapFactory mapFactory) throws IOException {
        Map<String, Object> map = mapFactory.newMap();
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.START_OBJECT) {
            token = parser.nextToken();
        }
        while (token == XContentParser.Token.FIELD_NAME) {
            String fieldName = parser.currentName();
            token = parser.nextToken();
            Object value = AbstractXContentParser.readValue(parser, mapFactory, token);
            map.put(fieldName, value);
            token = parser.nextToken();
        }
        return map;
    }

    static Map<String, String> readMapStrings(XContentParser parser, MapStringsFactory mapStringsFactory) throws IOException {
        Map<String, String> map = mapStringsFactory.newMap();
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.START_OBJECT) {
            token = parser.nextToken();
        }
        while (token == XContentParser.Token.FIELD_NAME) {
            String fieldName = parser.currentName();
            parser.nextToken();
            String value = parser.text();
            map.put(fieldName, value);
            token = parser.nextToken();
        }
        return map;
    }

    static List<Object> readList(XContentParser parser, MapFactory mapFactory) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.FIELD_NAME) {
            token = parser.nextToken();
        }
        if (token != XContentParser.Token.START_ARRAY) {
            throw new XContentParseException(parser.getTokenLocation(), "Failed to parse list:  expecting " + (Object)((Object)XContentParser.Token.START_ARRAY) + " but got " + (Object)((Object)token));
        }
        token = parser.nextToken();
        ArrayList<Object> list = new ArrayList<Object>();
        while (token != null && token != XContentParser.Token.END_ARRAY) {
            list.add(AbstractXContentParser.readValue(parser, mapFactory, token));
            token = parser.nextToken();
        }
        return list;
    }

    static Object readValue(XContentParser parser, MapFactory mapFactory, XContentParser.Token token) throws IOException {
        if (token == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            return parser.text();
        }
        if (token == XContentParser.Token.VALUE_NUMBER) {
            return parser.numberValue();
        }
        if (token == XContentParser.Token.VALUE_BOOLEAN) {
            return parser.booleanValue();
        }
        if (token == XContentParser.Token.START_OBJECT) {
            return AbstractXContentParser.readMap(parser, mapFactory);
        }
        if (token == XContentParser.Token.START_ARRAY) {
            return AbstractXContentParser.readList(parser, mapFactory);
        }
        if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
            return parser.binaryValue();
        }
        return null;
    }

    @Override
    public <T> T namedObject(Class<T> categoryClass, String name, Object context) throws IOException {
        return this.xContentRegistry.parseNamedObject(categoryClass, name, this, context);
    }

    @Override
    public NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @Override
    public abstract boolean isClosed();

    @Override
    public DeprecationHandler getDeprecationHandler() {
        return this.deprecationHandler;
    }

    static interface MapStringsFactory {
        public Map<String, String> newMap();
    }

    static interface MapFactory {
        public Map<String, Object> newMap();
    }
}

