/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.action.index;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.IndicesRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.MetaDataMappingService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportChannel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportRequestHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NodeMappingRefreshAction {
    private static final Logger logger = LogManager.getLogger(NodeMappingRefreshAction.class);
    public static final String ACTION_NAME = "internal:cluster/node/mapping/refresh";
    private final TransportService transportService;
    private final MetaDataMappingService metaDataMappingService;

    @Inject
    public NodeMappingRefreshAction(TransportService transportService, MetaDataMappingService metaDataMappingService) {
        this.transportService = transportService;
        this.metaDataMappingService = metaDataMappingService;
        transportService.registerRequestHandler(ACTION_NAME, NodeMappingRefreshRequest::new, "same", new NodeMappingRefreshTransportHandler());
    }

    public void nodeMappingRefresh(DiscoveryNode masterNode, NodeMappingRefreshRequest request) {
        if (masterNode == null) {
            logger.warn("can't send mapping refresh for [{}], no master known.", (Object)request.index());
            return;
        }
        this.transportService.sendRequest(masterNode, ACTION_NAME, request, EmptyTransportResponseHandler.INSTANCE_SAME);
    }

    public static class NodeMappingRefreshRequest
    extends TransportRequest
    implements IndicesRequest {
        private String index;
        private String indexUUID = "_na_";
        private String nodeId;

        public NodeMappingRefreshRequest() {
        }

        public NodeMappingRefreshRequest(String index, String indexUUID, String nodeId) {
            this.index = index;
            this.indexUUID = indexUUID;
            this.nodeId = nodeId;
        }

        @Override
        public String[] indices() {
            return new String[]{this.index};
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
        }

        public String index() {
            return this.index;
        }

        public String indexUUID() {
            return this.indexUUID;
        }

        public String nodeId() {
            return this.nodeId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.index);
            out.writeString(this.nodeId);
            out.writeString(this.indexUUID);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.index = in.readString();
            this.nodeId = in.readString();
            this.indexUUID = in.readString();
        }
    }

    private class NodeMappingRefreshTransportHandler
    implements TransportRequestHandler<NodeMappingRefreshRequest> {
        private NodeMappingRefreshTransportHandler() {
        }

        @Override
        public void messageReceived(NodeMappingRefreshRequest request, TransportChannel channel) throws Exception {
            NodeMappingRefreshAction.this.metaDataMappingService.refreshMapping(request.index(), request.indexUUID());
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }
}

