/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.ByteSizeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class DiskUsage
implements ToXContentFragment,
Writeable {
    final String nodeId;
    final String nodeName;
    final String path;
    final long totalBytes;
    final long freeBytes;

    public DiskUsage(String nodeId, String nodeName, String path, long totalBytes, long freeBytes) {
        this.nodeId = nodeId;
        this.nodeName = nodeName;
        this.freeBytes = freeBytes;
        this.totalBytes = totalBytes;
        this.path = path;
    }

    public DiskUsage(StreamInput in) throws IOException {
        this.nodeId = in.readString();
        this.nodeName = in.readString();
        this.path = in.readString();
        this.totalBytes = in.readVLong();
        this.freeBytes = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeId);
        out.writeString(this.nodeName);
        out.writeString(this.path);
        out.writeVLong(this.totalBytes);
        out.writeVLong(this.freeBytes);
    }

    private static double truncatePercent(double pct) {
        return (double)Math.round(pct * 10.0) / 10.0;
    }

    XContentBuilder toShortXContent(XContentBuilder builder) throws IOException {
        builder.field("path", this.path);
        builder.humanReadableField("total_bytes", "total", new ByteSizeValue(this.totalBytes));
        builder.humanReadableField("used_bytes", "used", new ByteSizeValue(this.getUsedBytes()));
        builder.humanReadableField("free_bytes", "free", new ByteSizeValue(this.freeBytes));
        builder.field("free_disk_percent", DiskUsage.truncatePercent(this.getFreeDiskAsPercentage()));
        builder.field("used_disk_percent", DiskUsage.truncatePercent(this.getUsedDiskAsPercentage()));
        return builder;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("node_id", this.nodeId);
        builder.field("node_name", this.nodeName);
        builder = this.toShortXContent(builder);
        return builder;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getPath() {
        return this.path;
    }

    public double getFreeDiskAsPercentage() {
        if (this.totalBytes == 0L) {
            return 100.0;
        }
        return 100.0 * ((double)this.freeBytes / (double)this.totalBytes);
    }

    public double getUsedDiskAsPercentage() {
        return 100.0 - this.getFreeDiskAsPercentage();
    }

    public long getFreeBytes() {
        return this.freeBytes;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getUsedBytes() {
        return this.getTotalBytes() - this.getFreeBytes();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiskUsage other = (DiskUsage)o;
        return Objects.equals(this.nodeId, other.nodeId) && Objects.equals(this.nodeName, other.nodeName) && Objects.equals(this.totalBytes, other.totalBytes) && Objects.equals(this.freeBytes, other.freeBytes);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.nodeName, this.path, this.totalBytes, this.freeBytes);
    }

    public String toString() {
        return "[" + this.nodeId + "][" + this.nodeName + "][" + this.path + "] free: " + new ByteSizeValue(this.getFreeBytes()) + "[" + Strings.format1Decimals(this.getFreeDiskAsPercentage(), "%") + "]";
    }
}

