/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster;

import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.AckedClusterStateTaskListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ack.AckedRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Priority;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;

public abstract class AckedClusterStateUpdateTask<Response>
extends ClusterStateUpdateTask
implements AckedClusterStateTaskListener {
    private final ActionListener<Response> listener;
    private final AckedRequest request;

    protected AckedClusterStateUpdateTask(AckedRequest request, ActionListener<Response> listener) {
        this(Priority.NORMAL, request, listener);
    }

    protected AckedClusterStateUpdateTask(Priority priority, AckedRequest request, ActionListener<Response> listener) {
        super(priority);
        this.listener = listener;
        this.request = request;
    }

    @Override
    public boolean mustAck(DiscoveryNode discoveryNode) {
        return true;
    }

    @Override
    public void onAllNodesAcked(@Nullable Exception e) {
        this.listener.onResponse(this.newResponse(e == null));
    }

    protected abstract Response newResponse(boolean var1);

    @Override
    public void onAckTimeout() {
        this.listener.onResponse(this.newResponse(false));
    }

    @Override
    public void onFailure(String source, Exception e) {
        this.listener.onFailure(e);
    }

    @Override
    public TimeValue ackTimeout() {
        return this.request.ackTimeout();
    }

    @Override
    public TimeValue timeout() {
        return this.request.masterNodeTimeout();
    }
}

