/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.security;

import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.Validatable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.security.RefreshPolicy;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.CollectionUtils;

public final class DeletePrivilegesRequest
implements Validatable {
    private final String application;
    private final String[] privileges;
    private final RefreshPolicy refreshPolicy;

    public DeletePrivilegesRequest(String application, String ... privileges) {
        this(application, privileges, (RefreshPolicy)null);
    }

    public DeletePrivilegesRequest(String application, String[] privileges, @Nullable RefreshPolicy refreshPolicy) {
        if (!Strings.hasText(application)) {
            throw new IllegalArgumentException("application name is required");
        }
        if (CollectionUtils.isEmpty(privileges)) {
            throw new IllegalArgumentException("privileges are required");
        }
        this.application = application;
        this.privileges = privileges;
        this.refreshPolicy = refreshPolicy == null ? RefreshPolicy.getDefault() : refreshPolicy;
    }

    public String getApplication() {
        return this.application;
    }

    public String[] getPrivileges() {
        return this.privileges;
    }

    public RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }
}

