/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionRequestValidationException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.ml.job.config.Job;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class ForecastJobRequest
extends ActionRequest
implements ToXContentObject {
    public static final ParseField DURATION = new ParseField("duration", new String[0]);
    public static final ParseField EXPIRES_IN = new ParseField("expires_in", new String[0]);
    public static final ConstructingObjectParser<ForecastJobRequest, Void> PARSER = new ConstructingObjectParser("forecast_job_request", a -> new ForecastJobRequest((String)a[0]));
    private final String jobId;
    private TimeValue duration;
    private TimeValue expiresIn;

    public ForecastJobRequest(String jobId) {
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public TimeValue getDuration() {
        return this.duration;
    }

    public void setDuration(TimeValue duration) {
        this.duration = duration;
    }

    public TimeValue getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(TimeValue expiresIn) {
        this.expiresIn = expiresIn;
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.duration, this.expiresIn);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ForecastJobRequest other = (ForecastJobRequest)obj;
        return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.duration, other.duration) && Objects.equals(this.expiresIn, other.expiresIn);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        if (this.duration != null) {
            builder.field(DURATION.getPreferredName(), this.duration.getStringRep());
        }
        if (this.expiresIn != null) {
            builder.field(EXPIRES_IN.getPreferredName(), this.expiresIn.getStringRep());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareString((request, val) -> request.setDuration(TimeValue.parseTimeValue(val, DURATION.getPreferredName())), DURATION);
        PARSER.declareString((request, val) -> request.setExpiresIn(TimeValue.parseTimeValue(val, EXPIRES_IN.getPreferredName())), EXPIRES_IN);
    }
}

