/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.graph;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.com.carrotsearch.hppc.ObjectIntHashMap;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ShardOperationFailedException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.ShardSearchFailure;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.graph.Connection;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.graph.Vertex;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class GraphExploreResponse
implements ToXContentObject {
    private long tookInMillis;
    private boolean timedOut = false;
    private ShardOperationFailedException[] shardFailures = ShardSearchFailure.EMPTY_ARRAY;
    private Map<Vertex.VertexId, Vertex> vertices;
    private Map<Connection.ConnectionId, Connection> connections;
    private boolean returnDetailedInfo;
    static final String RETURN_DETAILED_INFO_PARAM = "returnDetailedInfo";
    private static final ParseField TOOK = new ParseField("took", new String[0]);
    private static final ParseField TIMED_OUT = new ParseField("timed_out", new String[0]);
    private static final ParseField VERTICES = new ParseField("vertices", new String[0]);
    private static final ParseField CONNECTIONS = new ParseField("connections", new String[0]);
    private static final ParseField FAILURES = new ParseField("failures", new String[0]);
    private static final ConstructingObjectParser<GraphExploreResponse, Void> PARSER = new ConstructingObjectParser("GraphExploreResponsenParser", true, args -> {
        GraphExploreResponse result = new GraphExploreResponse();
        result.vertices = new HashMap<Vertex.VertexId, Vertex>();
        result.connections = new HashMap<Connection.ConnectionId, Connection>();
        result.tookInMillis = (Long)args[0];
        result.timedOut = (Boolean)args[1];
        List vertices = (List)args[2];
        List unresolvedConnections = (List)args[3];
        List failures = (List)args[4];
        for (Vertex vertex : vertices) {
            result.returnDetailedInfo = result.returnDetailedInfo || vertex.getFg() > 0L;
            result.vertices.put(vertex.getId(), vertex);
        }
        for (Connection.UnresolvedConnection unresolvedConnection : unresolvedConnections) {
            Connection resolvedConnection = unresolvedConnection.resolve(vertices);
            result.connections.put(resolvedConnection.getId(), resolvedConnection);
        }
        if (failures.size() > 0) {
            result.shardFailures = failures.toArray(new ShardSearchFailure[failures.size()]);
        }
        return result;
    });

    public GraphExploreResponse() {
    }

    public GraphExploreResponse(long tookInMillis, boolean timedOut, ShardOperationFailedException[] shardFailures, Map<Vertex.VertexId, Vertex> vertices, Map<Connection.ConnectionId, Connection> connections, boolean returnDetailedInfo) {
        this.tookInMillis = tookInMillis;
        this.timedOut = timedOut;
        this.shardFailures = shardFailures;
        this.vertices = vertices;
        this.connections = connections;
        this.returnDetailedInfo = returnDetailedInfo;
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    public long getTookInMillis() {
        return this.tookInMillis;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public ShardOperationFailedException[] getShardFailures() {
        return this.shardFailures;
    }

    public Collection<Connection> getConnections() {
        return this.connections.values();
    }

    public Collection<Connection.ConnectionId> getConnectionIds() {
        return this.connections.keySet();
    }

    public Connection getConnection(Connection.ConnectionId connectionId) {
        return this.connections.get(connectionId);
    }

    public Collection<Vertex> getVertices() {
        return this.vertices.values();
    }

    public Collection<Vertex.VertexId> getVertexIds() {
        return this.vertices.keySet();
    }

    public Vertex getVertex(Vertex.VertexId id) {
        return this.vertices.get(id);
    }

    public boolean isReturnDetailedInfo() {
        return this.returnDetailedInfo;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TOOK.getPreferredName(), this.tookInMillis);
        builder.field(TIMED_OUT.getPreferredName(), this.timedOut);
        builder.startArray(FAILURES.getPreferredName());
        if (this.shardFailures != null) {
            for (ShardOperationFailedException shardFailure : this.shardFailures) {
                builder.startObject();
                shardFailure.toXContent(builder, params);
                builder.endObject();
            }
        }
        builder.endArray();
        ObjectIntHashMap<Vertex> vertexNumbers = new ObjectIntHashMap<Vertex>(this.vertices.size());
        HashMap<String, String> extraParams = new HashMap<String, String>();
        extraParams.put(RETURN_DETAILED_INFO_PARAM, Boolean.toString(this.returnDetailedInfo));
        ToXContent.DelegatingMapParams extendedParams = new ToXContent.DelegatingMapParams(extraParams, params);
        builder.startArray(VERTICES.getPreferredName());
        for (Vertex vertex : this.vertices.values()) {
            builder.startObject();
            vertexNumbers.put(vertex, vertexNumbers.size());
            vertex.toXContent(builder, extendedParams);
            builder.endObject();
        }
        builder.endArray();
        builder.startArray(CONNECTIONS.getPreferredName());
        for (Connection connection : this.connections.values()) {
            builder.startObject();
            connection.toXContent(builder, extendedParams, vertexNumbers);
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static GraphExploreResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.apply(parser, null);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), TOOK);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), TIMED_OUT);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Vertex.fromXContent(p), VERTICES);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Connection.UnresolvedConnection.fromXContent(p), CONNECTIONS);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ShardSearchFailure.fromXContent(p), FAILURES);
    }
}

