/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.SearchRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.SearchResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.RequestOptions;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.RestHighLevelClient;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.RollupRequestConverters;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.core.AcknowledgedResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.rollup.DeleteRollupJobRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.rollup.GetRollupCapsRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.rollup.GetRollupCapsResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.rollup.GetRollupIndexCapsRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.rollup.GetRollupIndexCapsResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.rollup.GetRollupJobRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.rollup.GetRollupJobResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.rollup.PutRollupJobRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.rollup.StartRollupJobRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.rollup.StartRollupJobResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.rollup.StopRollupJobRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.rollup.StopRollupJobResponse;

public class RollupClient {
    private final RestHighLevelClient restHighLevelClient;

    RollupClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public AcknowledgedResponse putRollupJob(PutRollupJobRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::putJob, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void putRollupJobAsync(PutRollupJobRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::putJob, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public StartRollupJobResponse startRollupJob(StartRollupJobRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::startJob, options, StartRollupJobResponse::fromXContent, Collections.emptySet());
    }

    public void startRollupJobAsync(StartRollupJobRequest request, RequestOptions options, ActionListener<StartRollupJobResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::startJob, options, StartRollupJobResponse::fromXContent, listener, Collections.emptySet());
    }

    public StopRollupJobResponse stopRollupJob(StopRollupJobRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::stopJob, options, StopRollupJobResponse::fromXContent, Collections.emptySet());
    }

    public void stopRollupJobAsync(StopRollupJobRequest request, RequestOptions options, ActionListener<StopRollupJobResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::stopJob, options, StopRollupJobResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse deleteRollupJob(DeleteRollupJobRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::deleteJob, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void deleteRollupJobAsync(DeleteRollupJobRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::deleteJob, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetRollupJobResponse getRollupJob(GetRollupJobRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::getJob, options, GetRollupJobResponse::fromXContent, Collections.emptySet());
    }

    public void getRollupJobAsync(GetRollupJobRequest request, RequestOptions options, ActionListener<GetRollupJobResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::getJob, options, GetRollupJobResponse::fromXContent, listener, Collections.emptySet());
    }

    public SearchResponse search(SearchRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::search, options, SearchResponse::fromXContent, Collections.emptySet());
    }

    public void searchAsync(SearchRequest request, RequestOptions options, ActionListener<SearchResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::search, options, SearchResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetRollupCapsResponse getRollupCapabilities(GetRollupCapsRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::getRollupCaps, options, GetRollupCapsResponse::fromXContent, Collections.emptySet());
    }

    public void getRollupCapabilitiesAsync(GetRollupCapsRequest request, RequestOptions options, ActionListener<GetRollupCapsResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::getRollupCaps, options, GetRollupCapsResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetRollupIndexCapsResponse getRollupIndexCapabilities(GetRollupIndexCapsRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::getRollupIndexCaps, options, GetRollupIndexCapsResponse::fromXContent, Collections.emptySet());
    }

    public void getRollupIndexCapabilitiesAsync(GetRollupIndexCapsRequest request, RequestOptions options, ActionListener<GetRollupIndexCapsResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::getRollupIndexCaps, options, GetRollupIndexCapsResponse::fromXContent, listener, Collections.emptySet());
    }
}

