/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ingest.DeletePipelineRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ingest.GetPipelineRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ingest.PutPipelineRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ingest.SimulatePipelineRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.Request;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.RequestConverters;

final class IngestRequestConverters {
    private IngestRequestConverters() {
    }

    static Request getPipeline(GetPipelineRequest getPipelineRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ingest/pipeline").addCommaSeparatedPathParts(getPipelineRequest.getIds()).build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withMasterTimeout(getPipelineRequest.masterNodeTimeout());
        return request;
    }

    static Request putPipeline(PutPipelineRequest putPipelineRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ingest/pipeline").addPathPart(putPipelineRequest.getId()).build();
        Request request = new Request("PUT", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withTimeout(putPipelineRequest.timeout());
        parameters.withMasterTimeout(putPipelineRequest.masterNodeTimeout());
        request.setEntity(RequestConverters.createEntity(putPipelineRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request deletePipeline(DeletePipelineRequest deletePipelineRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ingest/pipeline").addPathPart(deletePipelineRequest.getId()).build();
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withTimeout(deletePipelineRequest.timeout());
        parameters.withMasterTimeout(deletePipelineRequest.masterNodeTimeout());
        return request;
    }

    static Request simulatePipeline(SimulatePipelineRequest simulatePipelineRequest) throws IOException {
        RequestConverters.EndpointBuilder builder = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ingest/pipeline");
        if (simulatePipelineRequest.getId() != null && !simulatePipelineRequest.getId().isEmpty()) {
            builder.addPathPart(simulatePipelineRequest.getId());
        }
        builder.addPathPartAsIs("_simulate");
        String endpoint = builder.build();
        Request request = new Request("POST", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.putParam("verbose", Boolean.toString(simulatePipelineRequest.isVerbose()));
        request.setEntity(RequestConverters.createEntity(simulatePipelineRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }
}

