/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.bootstrap;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.bootstrap.Natives;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.SuppressForbidden;

@SuppressForbidden(reason="exposes read-only view of system properties")
public final class BootstrapInfo {
    public static final String UNTRUSTED_CODEBASE = "/untrusted";
    private static final Dictionary<Object, Object> SYSTEM_PROPERTIES;

    private BootstrapInfo() {
    }

    public static boolean isNativesAvailable() {
        return Natives.JNA_AVAILABLE;
    }

    public static boolean isMemoryLocked() {
        return Natives.isMemoryLocked();
    }

    public static boolean isSystemCallFilterInstalled() {
        return Natives.isSystemCallFilterInstalled();
    }

    public static Dictionary<Object, Object> getSystemProperties() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertyAccess("*");
        }
        return SYSTEM_PROPERTIES;
    }

    public static void init() {
    }

    static {
        final Properties sysprops = System.getProperties();
        SYSTEM_PROPERTIES = new Dictionary<Object, Object>(){

            @Override
            public int size() {
                return sysprops.size();
            }

            @Override
            public boolean isEmpty() {
                return sysprops.isEmpty();
            }

            @Override
            public Enumeration<Object> keys() {
                return sysprops.keys();
            }

            @Override
            public Enumeration<Object> elements() {
                return sysprops.elements();
            }

            @Override
            public Object get(Object key) {
                return sysprops.get(key);
            }

            @Override
            public Object put(Object key, Object value) {
                throw new UnsupportedOperationException("treat system properties as immutable");
            }

            @Override
            public Object remove(Object key) {
                throw new UnsupportedOperationException("treat system properties as immutable");
            }
        };
    }
}

