/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.intervals;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.TwoPhaseIterator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.similarities.Similarity;

class IntervalScorer
extends Scorer {
    private final IntervalIterator intervals;
    private final Similarity.SimScorer simScorer;
    private float freq = -1.0f;
    private int lastScoredDoc = -1;

    protected IntervalScorer(Weight weight, IntervalIterator intervals, Similarity.SimScorer simScorer) {
        super(weight);
        this.intervals = intervals;
        this.simScorer = simScorer;
    }

    @Override
    public int docID() {
        return this.intervals.docID();
    }

    @Override
    public float score() throws IOException {
        this.ensureFreq();
        return this.simScorer.score(this.docID(), this.freq);
    }

    public Explanation explain(String topLevel) throws IOException {
        this.ensureFreq();
        Explanation freqExplanation = Explanation.match(this.freq, "intervalFreq=" + this.freq, new Explanation[0]);
        Explanation scoreExplanation = this.simScorer.explain(this.docID(), freqExplanation);
        return Explanation.match(scoreExplanation.getValue(), topLevel + ", result of:", scoreExplanation);
    }

    public float freq() throws IOException {
        this.ensureFreq();
        return this.freq;
    }

    private void ensureFreq() throws IOException {
        if (this.lastScoredDoc != this.docID()) {
            this.lastScoredDoc = this.docID();
            this.freq = 0.0f;
            do {
                this.freq = (float)((double)this.freq + 1.0 / (double)(this.intervals.end() - this.intervals.start() + 1));
            } while (this.intervals.nextInterval() != Integer.MAX_VALUE);
        }
    }

    @Override
    public DocIdSetIterator iterator() {
        return TwoPhaseIterator.asDocIdSetIterator(this.twoPhaseIterator());
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        return new TwoPhaseIterator(this.intervals){

            @Override
            public boolean matches() throws IOException {
                return IntervalScorer.this.intervals.nextInterval() != Integer.MAX_VALUE;
            }

            @Override
            public float matchCost() {
                return IntervalScorer.this.intervals.matchCost();
            }
        };
    }
}

