/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.BulkScorer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.LeafCollector;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Matches;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.MatchesUtils;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.ScorerSupplier;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.SegmentCacheable;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.TwoPhaseIterator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.Bits;

public abstract class Weight
implements SegmentCacheable {
    protected final Query parentQuery;

    protected Weight(Query query) {
        this.parentQuery = query;
    }

    public abstract void extractTerms(Set<Term> var1);

    public Matches matches(LeafReaderContext context, int doc) throws IOException {
        Scorer scorer = this.scorer(context);
        if (scorer == null) {
            return null;
        }
        TwoPhaseIterator twoPhase = scorer.twoPhaseIterator();
        if (twoPhase == null ? scorer.iterator().advance(doc) != doc : twoPhase.approximation().advance(doc) != doc || !twoPhase.matches()) {
            return null;
        }
        return MatchesUtils.MATCH_WITH_NO_TERMS;
    }

    public abstract Explanation explain(LeafReaderContext var1, int var2) throws IOException;

    public final Query getQuery() {
        return this.parentQuery;
    }

    public abstract Scorer scorer(LeafReaderContext var1) throws IOException;

    public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
        final Scorer scorer = this.scorer(context);
        if (scorer == null) {
            return null;
        }
        return new ScorerSupplier(){

            @Override
            public Scorer get(long leadCost) {
                return scorer;
            }

            @Override
            public long cost() {
                return scorer.iterator().cost();
            }
        };
    }

    public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
        Scorer scorer = this.scorer(context);
        if (scorer == null) {
            return null;
        }
        return new DefaultBulkScorer(scorer);
    }

    protected static class DefaultBulkScorer
    extends BulkScorer {
        private final Scorer scorer;
        private final DocIdSetIterator iterator;
        private final TwoPhaseIterator twoPhase;

        public DefaultBulkScorer(Scorer scorer) {
            if (scorer == null) {
                throw new NullPointerException();
            }
            this.scorer = scorer;
            this.iterator = scorer.iterator();
            this.twoPhase = scorer.twoPhaseIterator();
        }

        @Override
        public long cost() {
            return this.iterator.cost();
        }

        @Override
        public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
            collector.setScorer(this.scorer);
            if (this.scorer.docID() == -1 && min == 0 && max == Integer.MAX_VALUE) {
                DefaultBulkScorer.scoreAll(collector, this.iterator, this.twoPhase, acceptDocs);
                return Integer.MAX_VALUE;
            }
            int doc = this.scorer.docID();
            if (doc < min) {
                doc = this.twoPhase == null ? this.iterator.advance(min) : this.twoPhase.approximation().advance(min);
            }
            return DefaultBulkScorer.scoreRange(collector, this.iterator, this.twoPhase, acceptDocs, doc, max);
        }

        static int scoreRange(LeafCollector collector, DocIdSetIterator iterator, TwoPhaseIterator twoPhase, Bits acceptDocs, int currentDoc, int end) throws IOException {
            if (twoPhase == null) {
                while (currentDoc < end) {
                    if (acceptDocs == null || acceptDocs.get(currentDoc)) {
                        collector.collect(currentDoc);
                    }
                    currentDoc = iterator.nextDoc();
                }
                return currentDoc;
            }
            DocIdSetIterator approximation = twoPhase.approximation();
            while (currentDoc < end) {
                if ((acceptDocs == null || acceptDocs.get(currentDoc)) && twoPhase.matches()) {
                    collector.collect(currentDoc);
                }
                currentDoc = approximation.nextDoc();
            }
            return currentDoc;
        }

        static void scoreAll(LeafCollector collector, DocIdSetIterator iterator, TwoPhaseIterator twoPhase, Bits acceptDocs) throws IOException {
            if (twoPhase == null) {
                int doc = iterator.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if (acceptDocs == null || acceptDocs.get(doc)) {
                        collector.collect(doc);
                    }
                    doc = iterator.nextDoc();
                }
            } else {
                DocIdSetIterator approximation = twoPhase.approximation();
                int doc = approximation.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if ((acceptDocs == null || acceptDocs.get(doc)) && twoPhase.matches()) {
                        collector.collect(doc);
                    }
                    doc = approximation.nextDoc();
                }
            }
        }
    }
}

