/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.BulkScorer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.ConstantScoreScorer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.ConstantScoreWeight;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.FakeScorer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.LeafCollector;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.Bits;

public final class MatchAllDocsQuery
extends Query {
    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) {
        return new ConstantScoreWeight(this, boost){

            public String toString() {
                return "weight(" + MatchAllDocsQuery.this + ")";
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                return new ConstantScoreScorer((Weight)this, this.score(), DocIdSetIterator.all(context.reader().maxDoc()));
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }

            @Override
            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                final float score = this.score();
                final int maxDoc = context.reader().maxDoc();
                return new BulkScorer(){

                    @Override
                    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
                        max = Math.min(max, maxDoc);
                        FakeScorer scorer = new FakeScorer();
                        scorer.score = score;
                        collector.setScorer(scorer);
                        for (int doc = min; doc < max; ++doc) {
                            scorer.doc = doc;
                            if (acceptDocs != null && !acceptDocs.get(doc)) continue;
                            collector.collect(doc);
                        }
                        return max == maxDoc ? Integer.MAX_VALUE : max;
                    }

                    @Override
                    public long cost() {
                        return maxDoc;
                    }
                };
            }
        };
    }

    @Override
    public String toString(String field) {
        return "*:*";
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o);
    }

    @Override
    public int hashCode() {
        return this.classHash();
    }
}

