/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.queries.function.docvalues;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.queries.function.FunctionValues;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.queries.function.ValueSource;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.queries.function.ValueSourceScorer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.mutable.MutableValue;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.mutable.MutableValueLong;

public abstract class LongDocValues
extends FunctionValues {
    protected final ValueSource vs;

    public LongDocValues(ValueSource vs) {
        this.vs = vs;
    }

    @Override
    public byte byteVal(int doc) throws IOException {
        return (byte)this.longVal(doc);
    }

    @Override
    public short shortVal(int doc) throws IOException {
        return (short)this.longVal(doc);
    }

    @Override
    public float floatVal(int doc) throws IOException {
        return this.longVal(doc);
    }

    @Override
    public int intVal(int doc) throws IOException {
        return (int)this.longVal(doc);
    }

    @Override
    public abstract long longVal(int var1) throws IOException;

    @Override
    public double doubleVal(int doc) throws IOException {
        return this.longVal(doc);
    }

    @Override
    public boolean boolVal(int doc) throws IOException {
        return this.longVal(doc) != 0L;
    }

    @Override
    public String strVal(int doc) throws IOException {
        return Long.toString(this.longVal(doc));
    }

    @Override
    public Object objectVal(int doc) throws IOException {
        return this.exists(doc) ? Long.valueOf(this.longVal(doc)) : null;
    }

    @Override
    public String toString(int doc) throws IOException {
        return this.vs.description() + '=' + this.strVal(doc);
    }

    protected long externalToLong(String extVal) {
        return Long.parseLong(extVal);
    }

    @Override
    public ValueSourceScorer getRangeScorer(LeafReaderContext readerContext, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
        long upper;
        long lower;
        if (lowerVal == null) {
            lower = Long.MIN_VALUE;
        } else {
            lower = this.externalToLong(lowerVal);
            if (!includeLower && lower < Long.MAX_VALUE) {
                ++lower;
            }
        }
        if (upperVal == null) {
            upper = Long.MAX_VALUE;
        } else {
            upper = this.externalToLong(upperVal);
            if (!includeUpper && upper > Long.MIN_VALUE) {
                --upper;
            }
        }
        final long ll = lower;
        final long uu = upper;
        return new ValueSourceScorer(readerContext, this){

            @Override
            public boolean matches(int doc) throws IOException {
                if (!LongDocValues.this.exists(doc)) {
                    return false;
                }
                long val = LongDocValues.this.longVal(doc);
                return val >= ll && val <= uu;
            }
        };
    }

    @Override
    public FunctionValues.ValueFiller getValueFiller() {
        return new FunctionValues.ValueFiller(){
            private final MutableValueLong mval = new MutableValueLong();

            @Override
            public MutableValue getValue() {
                return this.mval;
            }

            @Override
            public void fillValue(int doc) throws IOException {
                this.mval.value = LongDocValues.this.longVal(doc);
                this.mval.exists = LongDocValues.this.exists(doc);
            }
        };
    }
}

