/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.DocValuesWriter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.DocsWithFieldSet;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.EmptyDocValuesProducer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.SegmentWriteState;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.Sorter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.SortingLeafReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.SortedNumericSelector;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.SortedNumericSortField;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.Counter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.RamUsageEstimator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.packed.PackedLongValues;

class SortedNumericDocValuesWriter
extends DocValuesWriter {
    private PackedLongValues.Builder pending;
    private PackedLongValues.Builder pendingCounts;
    private DocsWithFieldSet docsWithField;
    private final Counter iwBytesUsed;
    private long bytesUsed;
    private final FieldInfo fieldInfo;
    private int currentDoc = -1;
    private long[] currentValues = new long[8];
    private int currentUpto = 0;
    private PackedLongValues finalValues;
    private PackedLongValues finalValuesCount;

    public SortedNumericDocValuesWriter(FieldInfo fieldInfo, Counter iwBytesUsed) {
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        this.pending = PackedLongValues.deltaPackedBuilder(0.0f);
        this.pendingCounts = PackedLongValues.deltaPackedBuilder(0.0f);
        this.docsWithField = new DocsWithFieldSet();
        this.bytesUsed = this.pending.ramBytesUsed() + this.pendingCounts.ramBytesUsed() + this.docsWithField.ramBytesUsed() + RamUsageEstimator.sizeOf(this.currentValues);
        iwBytesUsed.addAndGet(this.bytesUsed);
    }

    public void addValue(int docID, long value) {
        assert (docID >= this.currentDoc);
        if (docID != this.currentDoc) {
            this.finishCurrentDoc();
            this.currentDoc = docID;
        }
        this.addOneValue(value);
        this.updateBytesUsed();
    }

    private void finishCurrentDoc() {
        if (this.currentDoc == -1) {
            return;
        }
        Arrays.sort(this.currentValues, 0, this.currentUpto);
        for (int i = 0; i < this.currentUpto; ++i) {
            this.pending.add(this.currentValues[i]);
        }
        this.pendingCounts.add(this.currentUpto);
        this.currentUpto = 0;
        this.docsWithField.add(this.currentDoc);
    }

    @Override
    public void finish(int maxDoc) {
        this.finishCurrentDoc();
    }

    private void addOneValue(long value) {
        if (this.currentUpto == this.currentValues.length) {
            this.currentValues = ArrayUtil.grow(this.currentValues, this.currentValues.length + 1);
        }
        this.currentValues[this.currentUpto] = value;
        ++this.currentUpto;
    }

    private void updateBytesUsed() {
        long newBytesUsed = this.pending.ramBytesUsed() + this.pendingCounts.ramBytesUsed() + this.docsWithField.ramBytesUsed() + RamUsageEstimator.sizeOf(this.currentValues);
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    @Override
    Sorter.DocComparator getDocComparator(int maxDoc, SortField sortField) throws IOException {
        assert (sortField instanceof SortedNumericSortField);
        assert (this.finalValues == null && this.finalValuesCount == null);
        this.finalValues = this.pending.build();
        this.finalValuesCount = this.pendingCounts.build();
        BufferedSortedNumericDocValues docValues = new BufferedSortedNumericDocValues(this.finalValues, this.finalValuesCount, this.docsWithField.iterator());
        SortedNumericSortField sf = (SortedNumericSortField)sortField;
        return Sorter.getDocComparator(maxDoc, sf, () -> null, () -> SortedNumericSelector.wrap(docValues, sf.getSelector(), sf.getNumericType()));
    }

    private long[][] sortDocValues(int maxDoc, Sorter.DocMap sortMap, SortedNumericDocValues oldValues) throws IOException {
        int docID;
        long[][] values = new long[maxDoc][];
        while ((docID = oldValues.nextDoc()) != Integer.MAX_VALUE) {
            int newDocID = sortMap.oldToNew(docID);
            long[] docValues = new long[oldValues.docValueCount()];
            for (int i = 0; i < docValues.length; ++i) {
                docValues[i] = oldValues.nextValue();
            }
            values[newDocID] = docValues;
        }
        return values;
    }

    @Override
    public void flush(SegmentWriteState state, Sorter.DocMap sortMap, DocValuesConsumer dvConsumer) throws IOException {
        PackedLongValues valueCounts;
        PackedLongValues values;
        if (this.finalValues == null) {
            values = this.pending.build();
            valueCounts = this.pendingCounts.build();
        } else {
            values = this.finalValues;
            valueCounts = this.finalValuesCount;
        }
        final long[][] sorted = sortMap != null ? this.sortDocValues(state.segmentInfo.maxDoc(), sortMap, new BufferedSortedNumericDocValues(values, valueCounts, this.docsWithField.iterator())) : (long[][])null;
        dvConsumer.addSortedNumericField(this.fieldInfo, new EmptyDocValuesProducer(){

            @Override
            public SortedNumericDocValues getSortedNumeric(FieldInfo fieldInfoIn) {
                if (fieldInfoIn != SortedNumericDocValuesWriter.this.fieldInfo) {
                    throw new IllegalArgumentException("wrong fieldInfo");
                }
                BufferedSortedNumericDocValues buf = new BufferedSortedNumericDocValues(values, valueCounts, SortedNumericDocValuesWriter.this.docsWithField.iterator());
                if (sorted == null) {
                    return buf;
                }
                return new SortingLeafReader.SortingSortedNumericDocValues(buf, sorted);
            }
        });
    }

    @Override
    DocIdSetIterator getDocIdSet() {
        return this.docsWithField.iterator();
    }

    private static class BufferedSortedNumericDocValues
    extends SortedNumericDocValues {
        final PackedLongValues.Iterator valuesIter;
        final PackedLongValues.Iterator valueCountsIter;
        final DocIdSetIterator docsWithField;
        private int valueCount;
        private int valueUpto;

        public BufferedSortedNumericDocValues(PackedLongValues values, PackedLongValues valueCounts, DocIdSetIterator docsWithField) {
            this.valuesIter = values.iterator();
            this.valueCountsIter = valueCounts.iterator();
            this.docsWithField = docsWithField;
        }

        @Override
        public int docID() {
            return this.docsWithField.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            for (int i = this.valueUpto; i < this.valueCount; ++i) {
                this.valuesIter.next();
            }
            int docID = this.docsWithField.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                this.valueCount = Math.toIntExact(this.valueCountsIter.next());
                this.valueUpto = 0;
            }
            return docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docValueCount() {
            return this.valueCount;
        }

        @Override
        public long nextValue() {
            if (this.valueUpto == this.valueCount) {
                throw new IllegalStateException();
            }
            ++this.valueUpto;
            return this.valuesIter.next();
        }

        @Override
        public long cost() {
            return this.docsWithField.cost();
        }
    }
}

