/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index;

import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.DocumentsWriterFlushControl;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.DocumentsWriterPerThreadPool;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.InfoStream;

abstract class FlushPolicy {
    protected LiveIndexWriterConfig indexWriterConfig;
    protected InfoStream infoStream;

    FlushPolicy() {
    }

    public abstract void onDelete(DocumentsWriterFlushControl var1, DocumentsWriterPerThreadPool.ThreadState var2);

    public void onUpdate(DocumentsWriterFlushControl control, DocumentsWriterPerThreadPool.ThreadState state) {
        this.onInsert(control, state);
        this.onDelete(control, state);
    }

    public abstract void onInsert(DocumentsWriterFlushControl var1, DocumentsWriterPerThreadPool.ThreadState var2);

    protected synchronized void init(LiveIndexWriterConfig indexWriterConfig) {
        this.indexWriterConfig = indexWriterConfig;
        this.infoStream = indexWriterConfig.getInfoStream();
    }

    protected DocumentsWriterPerThreadPool.ThreadState findLargestNonPendingWriter(DocumentsWriterFlushControl control, DocumentsWriterPerThreadPool.ThreadState perThreadState) {
        assert (perThreadState.dwpt.getNumDocsInRAM() > 0);
        DocumentsWriterPerThreadPool.ThreadState maxRamUsingThreadState = control.findLargestNonPendingWriter();
        assert (this.assertMessage("set largest ram consuming thread pending on lower watermark"));
        return maxRamUsingThreadState;
    }

    private boolean assertMessage(String s) {
        if (this.infoStream.isEnabled("FP")) {
            this.infoStream.message("FP", s);
        }
        return true;
    }
}

