/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.com.carrotsearch.hppc;

import org.apache.flink.elasticsearch6.shaded.com.carrotsearch.hppc.BitMixer;
import org.apache.flink.elasticsearch6.shaded.com.carrotsearch.hppc.HashOrderMixing;
import org.apache.flink.elasticsearch6.shaded.com.carrotsearch.hppc.ShortShortHashMap;

public class ShortShortScatterMap
extends ShortShortHashMap {
    public ShortShortScatterMap() {
        this(4);
    }

    public ShortShortScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ShortShortScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(short key) {
        return BitMixer.mixPhi(key);
    }

    public static ShortShortScatterMap from(short[] keys, short[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ShortShortScatterMap map = new ShortShortScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

