/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class FloatSerializer
extends TypeSerializerSingleton<Float> {
    private static final long serialVersionUID = 1L;
    public static final FloatSerializer INSTANCE = new FloatSerializer();
    private static final Float ZERO = Float.valueOf(0.0f);

    public boolean isImmutableType() {
        return true;
    }

    public Float createInstance() {
        return ZERO;
    }

    public Float copy(Float from) {
        return from;
    }

    public Float copy(Float from, Float reuse) {
        return from;
    }

    public int getLength() {
        return 4;
    }

    public void serialize(Float record, DataOutputView target) throws IOException {
        target.writeFloat(record.floatValue());
    }

    public Float deserialize(DataInputView source) throws IOException {
        return Float.valueOf(source.readFloat());
    }

    public Float deserialize(Float reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeFloat(source.readFloat());
    }

    public TypeSerializerSnapshot<Float> snapshotConfiguration() {
        return new FloatSerializerSnapshot();
    }

    public static final class FloatSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<Float> {
        public FloatSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

