/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.functions;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.cdc.common.data.DecimalData;
import org.apache.flink.cdc.common.data.LocalZonedTimestampData;
import org.apache.flink.cdc.common.data.TimestampData;
import org.apache.flink.cdc.common.data.ZonedTimestampData;
import org.apache.flink.cdc.common.utils.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemFunctionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SystemFunctionUtils.class);

    public static LocalZonedTimestampData currentTimestamp(long epochTime) {
        return LocalZonedTimestampData.fromEpochMillis(epochTime);
    }

    public static LocalZonedTimestampData now(long epochTime) {
        return LocalZonedTimestampData.fromEpochMillis(epochTime);
    }

    public static TimestampData localtimestamp(long epochTime, String timezone) {
        return TimestampData.fromLocalDateTime(Instant.ofEpochMilli(epochTime).atZone(ZoneId.of(timezone)).toLocalDateTime());
    }

    public static int localtime(long epochTime, String timezone) {
        return DateTimeUtils.timestampMillisToTime(SystemFunctionUtils.localtimestamp(epochTime, timezone).getMillisecond());
    }

    public static int currentTime(long epochTime, String timezone) {
        return DateTimeUtils.timestampMillisToTime(SystemFunctionUtils.localtimestamp(epochTime, timezone).getMillisecond());
    }

    public static int currentDate(long epochTime, String timezone) {
        return DateTimeUtils.timestampMillisToDate(SystemFunctionUtils.localtimestamp(epochTime, timezone).getMillisecond());
    }

    public static String fromUnixtime(long seconds, String timezone) {
        return DateTimeUtils.formatUnixTimestamp(seconds, TimeZone.getTimeZone(timezone));
    }

    public static String fromUnixtime(long seconds, String format, String timezone) {
        return DateTimeUtils.formatUnixTimestamp(seconds, format, TimeZone.getTimeZone(timezone));
    }

    public static long unixTimestamp(long epochTime, String timezone) {
        return epochTime / 1000L;
    }

    public static long unixTimestamp(String dateTimeStr, long epochTime, String timezone) {
        return DateTimeUtils.unixTimestamp(dateTimeStr, TimeZone.getTimeZone(timezone));
    }

    public static long unixTimestamp(String dateTimeStr, String format, long epochTime, String timezone) {
        return DateTimeUtils.unixTimestamp(dateTimeStr, format, TimeZone.getTimeZone(timezone));
    }

    public static String dateFormat(TimestampData timestamp, String format) {
        return DateTimeUtils.formatTimestampMillis(timestamp.getMillisecond(), format, TimeZone.getTimeZone("UTC"));
    }

    public static int toDate(String str, String timezone) {
        return SystemFunctionUtils.toDate(str, "yyyy-MM-dd", timezone);
    }

    public static int toDate(String str, String format, String timezone) {
        return DateTimeUtils.parseDate(str, format, timezone);
    }

    public static TimestampData toTimestamp(String str, String timezone) {
        return SystemFunctionUtils.toTimestamp(str, "yyyy-MM-dd HH:mm:ss", timezone);
    }

    public static TimestampData toTimestamp(String str, String format, String timezone) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setTimeZone(TimeZone.getTimeZone(timezone));
        try {
            return TimestampData.fromMillis(dateFormat.parse(str).getTime());
        }
        catch (ParseException e) {
            LOG.error("Unsupported date type convert: {}", (Object)str);
            throw new RuntimeException(e);
        }
    }

    public static Integer timestampDiff(String timeIntervalUnit, LocalZonedTimestampData fromTimestamp, LocalZonedTimestampData toTimestamp, String timezone) {
        if (fromTimestamp == null || toTimestamp == null) {
            return null;
        }
        return DateTimeUtils.timestampDiff(timeIntervalUnit, fromTimestamp.getEpochMillisecond(), timezone, toTimestamp.getEpochMillisecond(), timezone);
    }

    public static Integer timestampDiff(String timeIntervalUnit, TimestampData fromTimestamp, TimestampData toTimestamp, String timezone) {
        if (fromTimestamp == null || toTimestamp == null) {
            return null;
        }
        return DateTimeUtils.timestampDiff(timeIntervalUnit, fromTimestamp.getMillisecond(), "UTC", toTimestamp.getMillisecond(), "UTC");
    }

    public static Integer timestampDiff(String timeIntervalUnit, TimestampData fromTimestamp, LocalZonedTimestampData toTimestamp, String timezone) {
        if (fromTimestamp == null || toTimestamp == null) {
            return null;
        }
        return DateTimeUtils.timestampDiff(timeIntervalUnit, fromTimestamp.getMillisecond(), "UTC", toTimestamp.getEpochMillisecond(), timezone);
    }

    public static Integer timestampDiff(String timeIntervalUnit, LocalZonedTimestampData fromTimestamp, TimestampData toTimestamp, String timezone) {
        if (fromTimestamp == null || toTimestamp == null) {
            return null;
        }
        return DateTimeUtils.timestampDiff(timeIntervalUnit, fromTimestamp.getEpochMillisecond(), timezone, toTimestamp.getMillisecond(), "UTC");
    }

    public static Integer timestampdiff(String timeIntervalUnit, LocalZonedTimestampData fromTimestamp, LocalZonedTimestampData toTimestamp, String timezone) {
        return SystemFunctionUtils.timestampDiff(timeIntervalUnit, fromTimestamp, toTimestamp, timezone);
    }

    public static Integer timestampdiff(String timeIntervalUnit, TimestampData fromTimestamp, TimestampData toTimestamp, String timezone) {
        return SystemFunctionUtils.timestampDiff(timeIntervalUnit, fromTimestamp, toTimestamp, timezone);
    }

    public static Integer timestampdiff(String timeIntervalUnit, TimestampData fromTimestamp, LocalZonedTimestampData toTimestamp, String timezone) {
        return SystemFunctionUtils.timestampDiff(timeIntervalUnit, fromTimestamp, toTimestamp, timezone);
    }

    public static Integer timestampdiff(String timeIntervalUnit, LocalZonedTimestampData fromTimestamp, TimestampData toTimestamp, String timezone) {
        return SystemFunctionUtils.timestampDiff(timeIntervalUnit, fromTimestamp, toTimestamp, timezone);
    }

    public static LocalZonedTimestampData timestampadd(String timeIntervalUnit, Integer interval, LocalZonedTimestampData timePoint, String timezone) {
        if (interval == null || timePoint == null) {
            return null;
        }
        return LocalZonedTimestampData.fromEpochMillis(DateTimeUtils.timestampAdd(timeIntervalUnit, interval, timePoint.getEpochMillisecond(), timezone));
    }

    public static TimestampData timestampadd(String timeIntervalUnit, Integer interval, TimestampData timePoint, String timezone) {
        if (interval == null || timePoint == null) {
            return null;
        }
        return TimestampData.fromMillis(DateTimeUtils.timestampAdd(timeIntervalUnit, interval, timePoint.getMillisecond(), "UTC"));
    }

    public static boolean betweenAsymmetric(String value, String minValue, String maxValue) {
        if (value == null) {
            return false;
        }
        return value.compareTo(minValue) >= 0 && value.compareTo(maxValue) <= 0;
    }

    public static boolean betweenAsymmetric(Short value, short minValue, short maxValue) {
        if (value == null) {
            return false;
        }
        return value >= minValue && value <= maxValue;
    }

    public static boolean betweenAsymmetric(Integer value, int minValue, int maxValue) {
        if (value == null) {
            return false;
        }
        return value >= minValue && value <= maxValue;
    }

    public static boolean betweenAsymmetric(Long value, long minValue, long maxValue) {
        if (value == null) {
            return false;
        }
        return value >= minValue && value <= maxValue;
    }

    public static boolean betweenAsymmetric(Float value, float minValue, float maxValue) {
        if (value == null) {
            return false;
        }
        return value.floatValue() >= minValue && value.floatValue() <= maxValue;
    }

    public static boolean betweenAsymmetric(Double value, double minValue, double maxValue) {
        if (value == null) {
            return false;
        }
        return value >= minValue && value <= maxValue;
    }

    public static boolean betweenAsymmetric(BigDecimal value, BigDecimal minValue, BigDecimal maxValue) {
        if (value == null) {
            return false;
        }
        return value.compareTo(minValue) >= 0 && value.compareTo(maxValue) <= 0;
    }

    public static boolean betweenAsymmetric(DecimalData value, DecimalData minValue, DecimalData maxValue) {
        if (value == null) {
            return false;
        }
        return value.compareTo(minValue) >= 0 && value.compareTo(maxValue) <= 0;
    }

    public static boolean notBetweenAsymmetric(String value, String minValue, String maxValue) {
        return !SystemFunctionUtils.betweenAsymmetric(value, minValue, maxValue);
    }

    public static boolean notBetweenAsymmetric(Short value, short minValue, short maxValue) {
        return !SystemFunctionUtils.betweenAsymmetric(value, minValue, maxValue);
    }

    public static boolean notBetweenAsymmetric(Integer value, int minValue, int maxValue) {
        return !SystemFunctionUtils.betweenAsymmetric(value, minValue, maxValue);
    }

    public static boolean notBetweenAsymmetric(Long value, long minValue, long maxValue) {
        return !SystemFunctionUtils.betweenAsymmetric(value, minValue, maxValue);
    }

    public static boolean notBetweenAsymmetric(Float value, float minValue, float maxValue) {
        return !SystemFunctionUtils.betweenAsymmetric(value, minValue, maxValue);
    }

    public static boolean notBetweenAsymmetric(Double value, double minValue, double maxValue) {
        return !SystemFunctionUtils.betweenAsymmetric(value, minValue, maxValue);
    }

    public static boolean notBetweenAsymmetric(BigDecimal value, BigDecimal minValue, BigDecimal maxValue) {
        return !SystemFunctionUtils.betweenAsymmetric(value, minValue, maxValue);
    }

    public static boolean notBetweenAsymmetric(DecimalData value, DecimalData minValue, DecimalData maxValue) {
        return !SystemFunctionUtils.betweenAsymmetric(value, minValue, maxValue);
    }

    public static boolean in(String value, String ... str) {
        return Arrays.stream(str).anyMatch(item -> value.equals(item));
    }

    public static boolean in(Short value, Short ... values) {
        return Arrays.stream(values).anyMatch(item -> value.equals(item));
    }

    public static boolean in(Integer value, Integer ... values) {
        return Arrays.stream(values).anyMatch(item -> value.equals(item));
    }

    public static boolean in(Long value, Long ... values) {
        return Arrays.stream(values).anyMatch(item -> value.equals(item));
    }

    public static boolean in(Float value, Float ... values) {
        return Arrays.stream(values).anyMatch(item -> value.equals(item));
    }

    public static boolean in(Double value, Double ... values) {
        return Arrays.stream(values).anyMatch(item -> value.equals(item));
    }

    public static boolean in(BigDecimal value, BigDecimal ... values) {
        return Arrays.stream(values).anyMatch(item -> value.equals(item));
    }

    public static boolean in(DecimalData value, DecimalData ... values) {
        return Arrays.stream(values).anyMatch(item -> value.equals(item));
    }

    public static boolean notIn(String value, String ... values) {
        return !SystemFunctionUtils.in(value, values);
    }

    public static boolean notIn(Short value, Short ... values) {
        return !SystemFunctionUtils.in(value, values);
    }

    public static boolean notIn(Integer value, Integer ... values) {
        return !SystemFunctionUtils.in(value, values);
    }

    public static boolean notIn(Long value, Long ... values) {
        return !SystemFunctionUtils.in(value, values);
    }

    public static boolean notIn(Float value, Float ... values) {
        return !SystemFunctionUtils.in(value, values);
    }

    public static boolean notIn(Double value, Double ... values) {
        return !SystemFunctionUtils.in(value, values);
    }

    public static boolean notIn(BigDecimal value, BigDecimal ... values) {
        return !SystemFunctionUtils.in(value, values);
    }

    public static boolean notIn(DecimalData value, DecimalData ... values) {
        return !SystemFunctionUtils.in(value, values);
    }

    public static int charLength(String str) {
        return str.length();
    }

    public static String trim(String symbol, String target, String str) {
        return str.trim();
    }

    public static String regexpReplace(String str, String regex, String replacement) {
        if (str == null || regex == null || replacement == null) {
            return null;
        }
        try {
            return str.replaceAll(regex, Matcher.quoteReplacement(replacement));
        }
        catch (Exception e) {
            LOG.error(String.format("Exception in regexpReplace('%s', '%s', '%s')", str, regex, replacement), e);
            return null;
        }
    }

    public static String concat(String ... str) {
        return String.join((CharSequence)"", str);
    }

    public static boolean like(String str, String regex) {
        return Pattern.compile(regex).matcher(str).find();
    }

    public static boolean notLike(String str, String regex) {
        return !SystemFunctionUtils.like(str, regex);
    }

    public static String substr(String str, int beginIndex) {
        return SystemFunctionUtils.substring(str, beginIndex);
    }

    public static String substr(String str, int beginIndex, int length) {
        return SystemFunctionUtils.substring(str, beginIndex, length);
    }

    public static String substring(String str, int beginIndex) {
        return SystemFunctionUtils.substring(str, beginIndex, Integer.MAX_VALUE);
    }

    public static String substring(String str, int beginIndex, int length) {
        int startPos;
        if (length < 0) {
            LOG.error("length of 'substring(str, beginIndex, length)' must be >= 0 and Int type, but length = {}", (Object)length);
            throw new RuntimeException("length of 'substring(str, beginIndex, length)' must be >= 0 and Int type, but length = " + length);
        }
        if (length > Integer.MAX_VALUE || beginIndex > Integer.MAX_VALUE) {
            LOG.error("length or start of 'substring(str, beginIndex, length)' must be Int type, but length = {}, beginIndex = {}", (Object)beginIndex, (Object)length);
            throw new RuntimeException("length or start of 'substring(str, beginIndex, length)' must be Int type, but length = " + beginIndex + ", beginIndex = " + length);
        }
        if (str.isEmpty()) {
            return "";
        }
        if (beginIndex > 0) {
            startPos = beginIndex - 1;
            if (startPos >= str.length()) {
                return "";
            }
        } else if (beginIndex < 0) {
            startPos = str.length() + beginIndex;
            if (startPos < 0) {
                return "";
            }
        } else {
            startPos = 0;
        }
        int endPos = str.length() - startPos < length ? str.length() : startPos + length;
        return str.substring(startPos, endPos);
    }

    public static String upper(String str) {
        return str.toUpperCase();
    }

    public static String lower(String str) {
        return str.toLowerCase();
    }

    public static byte abs(byte b0) {
        return (byte)Math.abs(b0);
    }

    public static short abs(short b0) {
        return (short)Math.abs(b0);
    }

    public static int abs(int b0) {
        return Math.abs(b0);
    }

    public static long abs(long b0) {
        return Math.abs(b0);
    }

    public static float abs(float b0) {
        return Math.abs(b0);
    }

    public static double abs(double b0) {
        return Math.abs(b0);
    }

    public static double floor(double b0) {
        return Math.floor(b0);
    }

    public static float floor(float b0) {
        return (float)Math.floor(b0);
    }

    public static int floor(int b0, int b1) {
        int r = b0 % b1;
        if (r < 0) {
            r += b1;
        }
        return b0 - r;
    }

    public static long floor(long b0, long b1) {
        long r = b0 % b1;
        if (r < 0L) {
            r += b1;
        }
        return b0 - r;
    }

    public static double ceil(double b0) {
        return Math.ceil(b0);
    }

    public static float ceil(float b0) {
        return (float)Math.ceil(b0);
    }

    public static int ceil(int b0, int b1) {
        int r = b0 % b1;
        if (r > 0) {
            r -= b1;
        }
        return b0 - r;
    }

    public static long ceil(long b0, long b1) {
        return SystemFunctionUtils.floor(b0 + b1 - 1L, b1);
    }

    public static byte round(byte b0) {
        return SystemFunctionUtils.round(b0, 0);
    }

    public static byte round(byte b0, int b1) {
        return SystemFunctionUtils.round(BigDecimal.valueOf(b0), b1).byteValue();
    }

    public static short round(short b0) {
        return SystemFunctionUtils.round(b0, 0);
    }

    public static short round(short b0, int b1) {
        return SystemFunctionUtils.round(BigDecimal.valueOf(b0), b1).shortValue();
    }

    public static int round(int b0) {
        return SystemFunctionUtils.round(b0, 0);
    }

    public static int round(int b0, int b1) {
        return SystemFunctionUtils.round(BigDecimal.valueOf(b0), b1).intValue();
    }

    public static long round(long b0) {
        return SystemFunctionUtils.round(b0, 0);
    }

    public static long round(long b0, int b1) {
        return SystemFunctionUtils.round(BigDecimal.valueOf(b0), b1).longValue();
    }

    public static BigDecimal round(BigDecimal b0) {
        return SystemFunctionUtils.round(b0, 0);
    }

    public static DecimalData round(DecimalData b0) {
        return SystemFunctionUtils.round(b0, 0);
    }

    public static BigDecimal round(BigDecimal b0, int b1) {
        return b0.movePointRight(b1).setScale(0, RoundingMode.HALF_UP).movePointLeft(b1);
    }

    public static DecimalData round(DecimalData b0, int b1) {
        return DecimalData.fromBigDecimal(b0.toBigDecimal().movePointRight(b1).setScale(0, RoundingMode.HALF_UP).movePointLeft(b1), b0.precision(), b0.scale());
    }

    public static float round(float b0) {
        return SystemFunctionUtils.round(b0, 0);
    }

    public static float round(float b0, int b1) {
        return SystemFunctionUtils.round(BigDecimal.valueOf(b0), b1).floatValue();
    }

    public static double round(double b0) {
        return SystemFunctionUtils.round(b0, 0);
    }

    public static double round(double b0, int b1) {
        return SystemFunctionUtils.round(BigDecimal.valueOf(b0), b1).doubleValue();
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static String uuid(byte[] b) {
        return UUID.nameUUIDFromBytes(b).toString();
    }

    public static boolean valueEquals(Object object1, Object object2) {
        return object1 != null && object2 != null && object1.equals(object2);
    }

    public static Object coalesce(Object ... objects) {
        for (Object item : objects) {
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public static String castToString(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static Boolean castToBoolean(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Byte) {
            return !object.equals((byte)0);
        }
        if (object instanceof Short) {
            return !object.equals((short)0);
        }
        if (object instanceof Integer) {
            return !object.equals(0);
        }
        if (object instanceof Long) {
            return !object.equals(0L);
        }
        if (object instanceof Float) {
            return !object.equals(Float.valueOf(0.0f));
        }
        if (object instanceof Double) {
            return !object.equals(0.0);
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).compareTo(BigDecimal.ZERO) != 0;
        }
        if (object instanceof DecimalData) {
            return ((DecimalData)object).compareTo(DecimalData.zero(1, 0)) != 0;
        }
        return Boolean.valueOf(SystemFunctionUtils.castToString(object));
    }

    public static Byte castToByte(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (byte)((Boolean)object != false ? 1 : 0);
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).byteValue();
        }
        if (object instanceof DecimalData) {
            return ((DecimalData)object).toBigDecimal().byteValue();
        }
        if (object instanceof Double) {
            return ((Double)object).byteValue();
        }
        if (object instanceof Float) {
            return ((Float)object).byteValue();
        }
        String stringRep = SystemFunctionUtils.castToString(object);
        try {
            return Byte.valueOf(stringRep);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.valueOf(stringRep).byteValue();
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
    }

    public static Short castToShort(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (short)((Boolean)object != false ? 1 : 0);
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).shortValue();
        }
        if (object instanceof DecimalData) {
            return ((DecimalData)object).toBigDecimal().shortValue();
        }
        if (object instanceof Double) {
            return ((Double)object).shortValue();
        }
        if (object instanceof Float) {
            return ((Float)object).shortValue();
        }
        String stringRep = SystemFunctionUtils.castToString(object);
        try {
            return Short.valueOf(stringRep);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.valueOf(stringRep).shortValue();
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
    }

    public static Integer castToInteger(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).intValue();
        }
        if (object instanceof DecimalData) {
            return ((DecimalData)object).toBigDecimal().intValue();
        }
        if (object instanceof Double) {
            return ((Double)object).intValue();
        }
        if (object instanceof Float) {
            return ((Float)object).intValue();
        }
        String stringRep = SystemFunctionUtils.castToString(object);
        try {
            return Integer.valueOf(stringRep);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.valueOf(stringRep).intValue();
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
    }

    public static Long castToLong(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).longValue();
        }
        if (object instanceof DecimalData) {
            return ((DecimalData)object).toBigDecimal().longValue();
        }
        if (object instanceof Double) {
            return ((Double)object).longValue();
        }
        if (object instanceof Float) {
            return ((Float)object).longValue();
        }
        String stringRep = SystemFunctionUtils.castToString(object);
        try {
            return Long.valueOf(stringRep);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.valueOf(stringRep).longValue();
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
    }

    public static Float castToFloat(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return Float.valueOf((Boolean)object != false ? 1.0f : 0.0f);
        }
        if (object instanceof BigDecimal) {
            return Float.valueOf(((BigDecimal)object).floatValue());
        }
        if (object instanceof DecimalData) {
            return Float.valueOf(((DecimalData)object).toBigDecimal().floatValue());
        }
        if (object instanceof Double) {
            return Float.valueOf(((Double)object).floatValue());
        }
        if (object instanceof Float) {
            return (Float)object;
        }
        try {
            return Float.valueOf(SystemFunctionUtils.castObjectIntoString(object));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    public static Double castToDouble(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).doubleValue();
        }
        if (object instanceof DecimalData) {
            return ((DecimalData)object).toBigDecimal().doubleValue();
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        try {
            return Double.valueOf(SystemFunctionUtils.castObjectIntoString(object));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    public static BigDecimal castToBigDecimal(Object object, int precision, int scale) {
        BigDecimal bigDecimal;
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            object = (Boolean)object != false ? 1 : 0;
        }
        try {
            bigDecimal = new BigDecimal(SystemFunctionUtils.castObjectIntoString(object), new MathContext(precision));
            bigDecimal = bigDecimal.setScale(scale, RoundingMode.HALF_UP);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
        if (bigDecimal.precision() > precision) {
            return null;
        }
        return bigDecimal;
    }

    public static DecimalData castToDecimalData(Object object, int precision, int scale) {
        BigDecimal bigDecimal;
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            object = (Boolean)object != false ? 1 : 0;
        }
        try {
            bigDecimal = new BigDecimal(SystemFunctionUtils.castObjectIntoString(object), new MathContext(precision));
            bigDecimal = bigDecimal.setScale(scale, RoundingMode.HALF_UP);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
        if (bigDecimal.precision() > precision) {
            return null;
        }
        return DecimalData.fromBigDecimal(bigDecimal, precision, scale);
    }

    public static TimestampData castToTimestamp(Object object, String timezone) {
        if (object == null) {
            return null;
        }
        if (object instanceof LocalZonedTimestampData) {
            return TimestampData.fromLocalDateTime(LocalDateTime.ofInstant(((LocalZonedTimestampData)object).toInstant(), ZoneId.of(timezone)));
        }
        if (object instanceof ZonedTimestampData) {
            return TimestampData.fromLocalDateTime(LocalDateTime.ofInstant(((ZonedTimestampData)object).toInstant(), ZoneId.of(timezone)));
        }
        return TimestampData.fromLocalDateTime(LocalDateTime.parse(SystemFunctionUtils.castObjectIntoString(object)));
    }

    private static String castObjectIntoString(Object object) {
        if (object instanceof Boolean) {
            return Boolean.valueOf(SystemFunctionUtils.castToString(object)) != false ? "1" : "0";
        }
        return String.valueOf(object);
    }

    private static int universalCompares(Object lhs, Object rhs) {
        Class<?> rightClass;
        Class<?> leftClass = lhs.getClass();
        if (leftClass.equals(rightClass = rhs.getClass()) && lhs instanceof Comparable) {
            return ((Comparable)lhs).compareTo(rhs);
        }
        if (lhs instanceof Number && rhs instanceof Number) {
            return Double.compare(((Number)lhs).doubleValue(), ((Number)rhs).doubleValue());
        }
        throw new RuntimeException("Comparison of unsupported data types: " + leftClass.getName() + " and " + rightClass.getName());
    }

    public static boolean greaterThan(Object lhs, Object rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        return SystemFunctionUtils.universalCompares(lhs, rhs) > 0;
    }

    public static boolean greaterThanOrEqual(Object lhs, Object rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        return SystemFunctionUtils.universalCompares(lhs, rhs) >= 0;
    }

    public static boolean lessThan(Object lhs, Object rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        return SystemFunctionUtils.universalCompares(lhs, rhs) < 0;
    }

    public static boolean lessThanOrEqual(Object lhs, Object rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        return SystemFunctionUtils.universalCompares(lhs, rhs) <= 0;
    }
}

