/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.text.ParsingException;
import io.debezium.text.TokenStream;
import java.util.ArrayList;
import java.util.List;

class TableIdParser {
    private static final char SEPARATOR = '.';
    private static final String SINGLE_QUOTES = "''";
    private static final String DOUBLE_QUOTES = "\"\"";
    private static final String BACKTICKS = "``";

    TableIdParser() {
    }

    public static List<String> parse(String identifier) {
        TokenStream stream = new TokenStream(identifier, new TableIdTokenizer(identifier), true);
        stream.start();
        ArrayList<String> parts = new ArrayList<String>(3);
        while (stream.hasNext()) {
            parts.add(stream.consume().replace(SINGLE_QUOTES, "'").replace(DOUBLE_QUOTES, "\"").replace(BACKTICKS, "`"));
        }
        return parts;
    }

    private static class TableIdTokenizer
    implements TokenStream.Tokenizer {
        private final String identifier;

        public TableIdTokenizer(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public void tokenize(TokenStream.CharacterStream input, TokenStream.Tokens tokens) throws ParsingException {
            ParsingState previousState = null;
            ParsingState currentState = ParsingState.INITIAL;
            ParsingContext parsingContext = new ParsingContext(input, tokens);
            currentState.onEntry(parsingContext);
            while (input.hasNext()) {
                previousState = currentState;
                if ((currentState = currentState.handleCharacter(input.next(), parsingContext)) == previousState) continue;
                previousState.onExit(parsingContext);
                currentState.onEntry(parsingContext);
            }
            currentState.onExit(parsingContext);
            if (currentState != ParsingState.BEFORE_SEPARATOR && currentState != ParsingState.IN_IDENTIFIER) {
                throw new IllegalArgumentException("Invalid identifier: " + this.identifier);
            }
        }
    }

    private static class ParsingContext {
        final TokenStream.CharacterStream input;
        final TokenStream.Tokens tokens;
        int startOfLastToken;
        int lastIdentifierEnd;
        boolean escaped;
        char quotingChar;

        public ParsingContext(TokenStream.CharacterStream input, TokenStream.Tokens tokens) {
            this.input = input;
            this.tokens = tokens;
        }
    }

    private static enum ParsingState {
        INITIAL{

            @Override
            ParsingState handleCharacter(char c, ParsingContext context) {
                if (Character.isWhitespace(c)) {
                    return INITIAL;
                }
                if (c == '.') {
                    throw new IllegalArgumentException("Unexpected input: " + c);
                }
                if (ParsingState.isQuotingChar(c)) {
                    context.quotingChar = c;
                    return IN_QUOTED_IDENTIFIER;
                }
                return IN_IDENTIFIER;
            }
        }
        ,
        IN_IDENTIFIER{

            @Override
            void doOnEntry(ParsingContext context) {
                context.startOfLastToken = context.input.index();
                context.lastIdentifierEnd = context.input.index();
            }

            @Override
            void doOnExit(ParsingContext context) {
                context.tokens.addToken(context.input.position(context.startOfLastToken), context.startOfLastToken, context.lastIdentifierEnd + 1);
            }

            @Override
            ParsingState handleCharacter(char c, ParsingContext context) {
                if (Character.isWhitespace(c)) {
                    return BEFORE_SEPARATOR;
                }
                if (c == '.') {
                    return AFTER_SEPARATOR;
                }
                context.lastIdentifierEnd = context.input.index();
                return IN_IDENTIFIER;
            }
        }
        ,
        BEFORE_SEPARATOR{

            @Override
            ParsingState handleCharacter(char c, ParsingContext context) {
                if (Character.isWhitespace(c)) {
                    return BEFORE_SEPARATOR;
                }
                if (c == '.') {
                    return AFTER_SEPARATOR;
                }
                throw new IllegalArgumentException("Unexpected input: " + c);
            }
        }
        ,
        AFTER_SEPARATOR{

            @Override
            ParsingState handleCharacter(char c, ParsingContext context) {
                if (Character.isWhitespace(c)) {
                    return AFTER_SEPARATOR;
                }
                if (c == '.') {
                    throw new IllegalArgumentException("Unexpected input: " + c);
                }
                if (ParsingState.isQuotingChar(c)) {
                    context.quotingChar = c;
                    return IN_QUOTED_IDENTIFIER;
                }
                return IN_IDENTIFIER;
            }
        }
        ,
        IN_QUOTED_IDENTIFIER{

            @Override
            ParsingState handleCharacter(char c, ParsingContext context) {
                if (c == context.quotingChar) {
                    if (context.escaped) {
                        context.escaped = false;
                        return IN_QUOTED_IDENTIFIER;
                    }
                    if (context.input.isNext(context.quotingChar)) {
                        context.escaped = true;
                        return IN_QUOTED_IDENTIFIER;
                    }
                    context.lastIdentifierEnd = context.input.index();
                    return BEFORE_SEPARATOR;
                }
                return IN_QUOTED_IDENTIFIER;
            }

            @Override
            void doOnEntry(ParsingContext context) {
                context.startOfLastToken = context.input.index();
            }

            @Override
            void doOnExit(ParsingContext context) {
                context.quotingChar = '\u0000';
                context.tokens.addToken(context.input.position(context.startOfLastToken + 1), context.startOfLastToken + 1, context.lastIdentifierEnd);
            }
        };


        abstract ParsingState handleCharacter(char var1, ParsingContext var2);

        void onEntry(ParsingContext context) {
            this.doOnEntry(context);
        }

        void doOnEntry(ParsingContext context) {
        }

        void onExit(ParsingContext context) {
            this.doOnExit(context);
        }

        void doOnExit(ParsingContext context) {
        }

        private static boolean isQuotingChar(char c) {
            return c == '\"' || c == '\'' || c == '`';
        }
    }
}

