/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;

public class CliOptions {
    private final boolean isPrintHelp;
    private final String sessionId;
    private final URL initFile;
    private final URL sqlFile;
    private final String historyFilePath;
    private final Properties sessionConfig;

    private CliOptions(boolean isPrintHelp, String sessionId, URL initFile, URL sqlFile, String historyFilePath, Properties sessionConfig) {
        this.isPrintHelp = isPrintHelp;
        this.sessionId = sessionId;
        this.initFile = initFile;
        this.sqlFile = sqlFile;
        this.historyFilePath = historyFilePath;
        this.sessionConfig = sessionConfig;
    }

    public boolean isPrintHelp() {
        return this.isPrintHelp;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    @Nullable
    public URL getInitFile() {
        return this.initFile;
    }

    @Nullable
    public URL getSqlFile() {
        return this.sqlFile;
    }

    public String getHistoryFilePath() {
        return this.historyFilePath;
    }

    public Properties getSessionConfig() {
        return this.sessionConfig;
    }

    public static class GatewayCliOptions
    extends CliOptions {
        @Nullable
        private final URL gatewayAddress;

        GatewayCliOptions(boolean isPrintHelp, String sessionId, URL initFile, URL sqlFile, String historyFilePath, @Nullable URL gatewayAddress, Properties sessionConfig) {
            super(isPrintHelp, sessionId, initFile, sqlFile, historyFilePath, sessionConfig);
            this.gatewayAddress = gatewayAddress;
        }

        public Optional<URL> getGatewayAddress() {
            return Optional.ofNullable(this.gatewayAddress);
        }
    }

    public static class EmbeddedCliOptions
    extends CliOptions {
        private final List<URL> jars;
        private final List<URL> libraryDirs;
        private final Configuration pythonConfiguration;

        public EmbeddedCliOptions(boolean isPrintHelp, String sessionId, URL initFile, URL sqlFile, String historyFilePath, List<URL> jars, List<URL> libraryDirs, Configuration pythonConfiguration, Properties sessionConfig) {
            super(isPrintHelp, sessionId, initFile, sqlFile, historyFilePath, sessionConfig);
            this.jars = jars;
            this.libraryDirs = libraryDirs;
            this.pythonConfiguration = pythonConfiguration;
        }

        public List<URL> getJars() {
            return this.jars;
        }

        public List<URL> getLibraryDirs() {
            return this.libraryDirs;
        }

        public Configuration getPythonConfiguration() {
            return this.pythonConfiguration;
        }
    }
}

