/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.client.gateway.ResultDescriptor;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.TypedResult;
import org.apache.flink.table.client.gateway.result.ChangelogResult;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.utils.print.PrintStyle;
import org.apache.flink.table.utils.print.RowDataToStringConverter;
import org.apache.flink.table.utils.print.TableauStyle;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.jline.terminal.Terminal;

public class CliTableauResultView
implements AutoCloseable {
    private final Terminal terminal;
    private final ResultDescriptor resultDescriptor;
    private final ChangelogResult collectResult;
    private final ExecutorService displayResultExecutorService;

    public CliTableauResultView(Terminal terminal, ResultDescriptor resultDescriptor) {
        this(terminal, resultDescriptor, (ChangelogResult)resultDescriptor.createResult());
    }

    @VisibleForTesting
    public CliTableauResultView(Terminal terminal, ResultDescriptor resultDescriptor, ChangelogResult collectResult) {
        this.terminal = terminal;
        this.resultDescriptor = resultDescriptor;
        this.collectResult = collectResult;
        this.displayResultExecutorService = Executors.newSingleThreadExecutor((ThreadFactory)new ExecutorThreadFactory("CliTableauResultView"));
    }

    public void displayResults() throws SqlExecutionException {
        AtomicInteger receivedRowCount = new AtomicInteger(0);
        Future<?> resultFuture = this.displayResultExecutorService.submit(() -> {
            if (this.resultDescriptor.isStreamingMode()) {
                this.printStreamingResults(receivedRowCount);
            } else {
                this.printBatchResults(receivedRowCount);
            }
        });
        this.terminal.handle(Terminal.Signal.INT, signal -> resultFuture.cancel(true));
        boolean cleanUpQuery = true;
        try {
            resultFuture.get();
            cleanUpQuery = false;
        }
        catch (CancellationException e) {
            this.terminal.writer().println("Query terminated, received a total of " + receivedRowCount.get() + " " + this.getRowTerm(receivedRowCount));
            this.terminal.flush();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof SqlExecutionException) {
                throw (SqlExecutionException)e.getCause();
            }
            throw new SqlExecutionException("unknown exception", e.getCause());
        }
        catch (InterruptedException e) {
            throw new SqlExecutionException("Query interrupted", e);
        }
        finally {
            this.checkAndCleanUpQuery(cleanUpQuery);
        }
    }

    @Override
    public void close() {
        this.displayResultExecutorService.shutdown();
    }

    private void checkAndCleanUpQuery(boolean cleanUpQuery) {
        if (cleanUpQuery) {
            this.collectResult.close();
        }
    }

    private void printBatchResults(AtomicInteger receivedRowCount) {
        List<RowData> resultRows = this.waitBatchResults();
        receivedRowCount.addAndGet(resultRows.size());
        TableauStyle style = PrintStyle.tableauWithDataInferredColumnWidths((ResolvedSchema)this.resultDescriptor.getResultSchema(), (RowDataToStringConverter)this.resultDescriptor.getRowDataStringConverter(), (int)this.resultDescriptor.maxColumnWidth(), (boolean)false, (boolean)false);
        style.print(resultRows.iterator(), this.terminal.writer());
    }

    private void printStreamingResults(AtomicInteger receivedRowCount) {
        TableauStyle style = PrintStyle.tableauWithTypeInferredColumnWidths((ResolvedSchema)this.resultDescriptor.getResultSchema(), (RowDataToStringConverter)this.resultDescriptor.getRowDataStringConverter(), (int)this.resultDescriptor.maxColumnWidth(), (boolean)false, (boolean)true);
        style.printBorderLine(this.terminal.writer());
        style.printColumnNamesTableauRow(this.terminal.writer());
        style.printBorderLine(this.terminal.writer());
        this.terminal.flush();
        block7: while (true) {
            TypedResult<List<RowData>> result = this.collectResult.retrieveChanges();
            switch (result.getType()) {
                case EMPTY: {
                    try {
                        Thread.sleep(1L);
                        break;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                case EOS: {
                    if (receivedRowCount.get() > 0) {
                        style.printBorderLine(this.terminal.writer());
                    }
                    String rowTerm = this.getRowTerm(receivedRowCount);
                    this.terminal.writer().println("Received a total of " + receivedRowCount.get() + " " + rowTerm);
                    this.terminal.flush();
                    return;
                }
                case PAYLOAD: {
                    List<RowData> changes = result.getPayload();
                    Iterator<RowData> iterator = changes.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block7;
                        RowData change = iterator.next();
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        style.printTableauRow(style.rowFieldsToString(change), this.terminal.writer());
                        receivedRowCount.incrementAndGet();
                    }
                }
                default: {
                    throw new SqlExecutionException("Unknown result type: " + (Object)((Object)result.getType()));
                }
            }
        }
    }

    private List<RowData> waitBatchResults() {
        ArrayList<RowData> resultRows = new ArrayList<RowData>();
        while (true) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            TypedResult<List<RowData>> result = this.collectResult.retrieveChanges();
            if (result.getType() == TypedResult.ResultType.EOS) break;
            if (result.getType() != TypedResult.ResultType.PAYLOAD) continue;
            resultRows.addAll((Collection<RowData>)result.getPayload());
        }
        return resultRows;
    }

    private String getRowTerm(AtomicInteger receivedRowCount) {
        return receivedRowCount.get() > 1 ? "rows" : "row";
    }
}

