/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericRecord;
import org.apache.flink.formats.avro.AvroDeserializationSchema;
import org.apache.flink.formats.avro.AvroToRowDataConverters;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

@PublicEvolving
public class AvroRowDataDeserializationSchema
implements DeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private final DeserializationSchema<GenericRecord> nestedSchema;
    private final TypeInformation<RowData> typeInfo;
    private final AvroToRowDataConverters.AvroToRowDataConverter runtimeConverter;

    public AvroRowDataDeserializationSchema(RowType rowType, TypeInformation<RowData> typeInfo) {
        this(AvroDeserializationSchema.forGeneric(AvroSchemaConverter.convertToSchema((LogicalType)rowType)), AvroToRowDataConverters.createRowConverter(rowType), typeInfo);
    }

    public AvroRowDataDeserializationSchema(DeserializationSchema<GenericRecord> nestedSchema, AvroToRowDataConverters.AvroToRowDataConverter runtimeConverter, TypeInformation<RowData> typeInfo) {
        this.nestedSchema = nestedSchema;
        this.typeInfo = typeInfo;
        this.runtimeConverter = runtimeConverter;
    }

    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.nestedSchema.open(context);
    }

    public RowData deserialize(byte[] message) throws IOException {
        try {
            GenericRecord deserialize = (GenericRecord)this.nestedSchema.deserialize(message);
            return (RowData)this.runtimeConverter.convert(deserialize);
        }
        catch (Exception e) {
            throw new IOException("Failed to deserialize Avro record.", e);
        }
    }

    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.typeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvroRowDataDeserializationSchema that = (AvroRowDataDeserializationSchema)o;
        return this.nestedSchema.equals(that.nestedSchema) && this.typeInfo.equals(that.typeInfo);
    }

    public int hashCode() {
        return Objects.hash(this.nestedSchema, this.typeInfo);
    }
}

