/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.utils;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CollectionSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.api.common.SerializableSerializer;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.AvroUtils;
import org.apache.flink.api.java.typeutils.runtime.KryoRegistration;
import org.apache.flink.avro.shaded.org.apache.avro.Schema;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericArray;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericData;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericDatumReader;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericDatumWriter;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericRecord;
import org.apache.flink.avro.shaded.org.apache.avro.io.BinaryDecoder;
import org.apache.flink.avro.shaded.org.apache.avro.io.BinaryEncoder;
import org.apache.flink.avro.shaded.org.apache.avro.io.DecoderFactory;
import org.apache.flink.avro.shaded.org.apache.avro.io.EncoderFactory;
import org.apache.flink.formats.avro.typeutils.AvroSerializer;
import org.apache.flink.formats.avro.typeutils.AvroTypeInfo;

public class AvroKryoSerializerUtils
extends AvroUtils {
    public void addAvroSerializersIfRequired(SerializerConfig reg, Class<?> type) {
        if (Schema.class.isAssignableFrom(type) || GenericRecord.class.isAssignableFrom(type) || GenericArray.class.isAssignableFrom(type)) {
            SerializerConfigImpl regImpl = (SerializerConfigImpl)reg;
            regImpl.registerTypeWithKryoSerializer(GenericData.Record.class, AvroGenericRecordSerializer.class);
            regImpl.registerTypeWithKryoSerializer(GenericData.Array.class, AvroGenericDataArraySerializer.class);
            regImpl.addDefaultKryoSerializer(Schema.class, AvroSchemaSerializer.class);
        }
    }

    public void addAvroGenericDataArrayRegistration(LinkedHashMap<String, KryoRegistration> kryoRegistrations) {
        kryoRegistrations.put(GenericData.Array.class.getName(), new KryoRegistration(GenericData.Array.class, new SerializableSerializer((Serializer)new AvroGenericDataArraySerializer())));
    }

    public <T> TypeSerializer<T> createAvroSerializer(Class<T> type) {
        return new AvroSerializer<T>(type);
    }

    public <T> TypeInformation<T> createAvroTypeInfo(Class<T> type) {
        return new AvroTypeInfo<T>(type);
    }

    static <T> byte[] avroSerializeToBytes(Schema schema, T o) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder(out, null);
        GenericDatumWriter<T> datumWriter = new GenericDatumWriter<T>(schema);
        datumWriter.write(o, encoder);
        encoder.flush();
        return out.toByteArray();
    }

    static <T> T avroDeserializeFromBytes(Schema schema, byte[] bytes) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(in, null);
            GenericDatumReader<Object> datumReader = new GenericDatumReader<Object>(schema);
            T t = datumReader.read(null, decoder);
            return t;
        }
    }

    public static class AvroGenericDataArraySerializer
    extends CollectionSerializer<GenericData.Array>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void write(Kryo kryo, Output output, GenericData.Array array) {
            String schemaAsString = array.getSchema().toString();
            output.writeString(schemaAsString);
            try {
                byte[] bytes = AvroKryoSerializerUtils.avroSerializeToBytes(array.getSchema(), array);
                output.writeVarInt(bytes.length, true);
                output.write(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public GenericData.Array read(Kryo kryo, Input input, Class<? extends GenericData.Array> type) {
            String schemaAsString = input.readString();
            Schema.Parser schemaParser = new Schema.Parser();
            Schema schema = schemaParser.parse(schemaAsString);
            int bytesLength = input.readVarInt(true);
            byte[] bytes = input.readBytes(bytesLength);
            try {
                return (GenericData.Array)AvroKryoSerializerUtils.avroDeserializeFromBytes(schema, bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public GenericData.Array createCopy(Kryo kryo, GenericData.Array original) {
            String schemaAsString = original.getSchema().toString(false);
            Schema.Parser schemaParser = new Schema.Parser();
            Schema schema = schemaParser.parse(schemaAsString);
            return new GenericData.Array(schema, Collections.emptyList());
        }
    }

    public static class AvroGenericRecordSerializer
    extends Serializer<GenericData.Record>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void write(Kryo kryo, Output output, GenericData.Record record) {
            String schemaAsString = record.getSchema().toString();
            output.writeString(schemaAsString);
            try {
                byte[] bytes = AvroKryoSerializerUtils.avroSerializeToBytes(record.getSchema(), record);
                output.writeVarInt(bytes.length, true);
                output.write(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public GenericData.Record read(Kryo kryo, Input input, Class<? extends GenericData.Record> type) {
            String schemaAsString = input.readString();
            Schema.Parser schemaParser = new Schema.Parser();
            Schema schema = schemaParser.parse(schemaAsString);
            int bytesLength = input.readVarInt(true);
            byte[] bytes = input.readBytes(bytesLength);
            try {
                return (GenericData.Record)AvroKryoSerializerUtils.avroDeserializeFromBytes(schema, bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class AvroSchemaSerializer
    extends Serializer<Schema>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void write(Kryo kryo, Output output, Schema object) {
            String schemaAsString = object.toString();
            output.writeString(schemaAsString);
        }

        public Schema read(Kryo kryo, Input input, Class<? extends Schema> type) {
            String schemaAsString = input.readString();
            Schema.Parser sParser = new Schema.Parser();
            return sParser.parse(schemaAsString);
        }
    }
}

