/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.ByteUtils;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class OffsetForLeaderEpochResponseData
implements ApiMessage {
    int throttleTimeMs;
    OffsetForLeaderTopicResultCollection topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("topics", new ArrayOf(OffsetForLeaderTopicResult.SCHEMA_0), "Each topic we fetched offsets for."));
    public static final Schema SCHEMA_1 = new Schema(new Field("topics", new ArrayOf(OffsetForLeaderTopicResult.SCHEMA_1), "Each topic we fetched offsets for."));
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 4;

    public OffsetForLeaderEpochResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public OffsetForLeaderEpochResponseData() {
        this.throttleTimeMs = 0;
        this.topics = new OffsetForLeaderTopicResultCollection(0);
    }

    @Override
    public short apiKey() {
        return 23;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 4;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        OffsetForLeaderTopicResultCollection newCollection;
        int arrayLength;
        this.throttleTimeMs = _version >= 2 ? _readable.readInt() : 0;
        if (_version >= 4) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new OffsetForLeaderTopicResultCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new OffsetForLeaderTopicResult(_readable, _version));
            }
            this.topics = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new OffsetForLeaderTopicResultCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new OffsetForLeaderTopicResult(_readable, _version));
            }
            this.topics = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _writable.writeInt(this.throttleTimeMs);
        }
        if (_version >= 4) {
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            for (OffsetForLeaderTopicResult topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.topics.size());
            for (OffsetForLeaderTopicResult topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 4) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _size.addBytes(4);
        }
        if (_version >= 4) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        } else {
            _size.addBytes(4);
        }
        for (OffsetForLeaderTopicResult topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 4) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OffsetForLeaderEpochResponseData)) {
            return false;
        }
        OffsetForLeaderEpochResponseData other = (OffsetForLeaderEpochResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    @Override
    public OffsetForLeaderEpochResponseData duplicate() {
        OffsetForLeaderEpochResponseData _duplicate = new OffsetForLeaderEpochResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        OffsetForLeaderTopicResultCollection newTopics = new OffsetForLeaderTopicResultCollection(this.topics.size());
        for (OffsetForLeaderTopicResult _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "OffsetForLeaderEpochResponseData(throttleTimeMs=" + this.throttleTimeMs + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public OffsetForLeaderTopicResultCollection topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public OffsetForLeaderEpochResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public OffsetForLeaderEpochResponseData setTopics(OffsetForLeaderTopicResultCollection v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", new ArrayOf(OffsetForLeaderTopicResult.SCHEMA_1), "Each topic we fetched offsets for."));
        SCHEMA_4 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", new CompactArrayOf(OffsetForLeaderTopicResult.SCHEMA_4), "Each topic we fetched offsets for."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
    }

    public static class OffsetForLeaderTopicResultCollection
    extends ImplicitLinkedHashMultiCollection<OffsetForLeaderTopicResult> {
        public OffsetForLeaderTopicResultCollection() {
        }

        public OffsetForLeaderTopicResultCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public OffsetForLeaderTopicResultCollection(Iterator<OffsetForLeaderTopicResult> iterator) {
            super(iterator);
        }

        @Override
        public OffsetForLeaderTopicResult find(String topic) {
            OffsetForLeaderTopicResult _key = new OffsetForLeaderTopicResult();
            _key.setTopic(topic);
            return this.find(_key);
        }

        @Override
        public List<OffsetForLeaderTopicResult> findAll(String topic) {
            OffsetForLeaderTopicResult _key = new OffsetForLeaderTopicResult();
            _key.setTopic(topic);
            return this.findAll(_key);
        }

        public OffsetForLeaderTopicResultCollection duplicate() {
            OffsetForLeaderTopicResultCollection _duplicate = new OffsetForLeaderTopicResultCollection(this.size());
            for (OffsetForLeaderTopicResult _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class EpochEndOffset
    implements Message {
        short errorCode;
        int partition;
        int leaderEpoch;
        long endOffset;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code 0, or if there was no error."), new Field("partition", Type.INT32, "The partition index."), new Field("end_offset", Type.INT64, "The end offset of the epoch."));
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 4;

        public EpochEndOffset(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public EpochEndOffset() {
            this.errorCode = 0;
            this.partition = 0;
            this.leaderEpoch = -1;
            this.endOffset = -1L;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 4;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EpochEndOffset");
            }
            this.errorCode = _readable.readShort();
            this.partition = _readable.readInt();
            this.leaderEpoch = _version >= 1 ? _readable.readInt() : -1;
            this.endOffset = _readable.readLong();
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            _writable.writeInt(this.partition);
            if (_version >= 1) {
                _writable.writeInt(this.leaderEpoch);
            }
            _writable.writeLong(this.endOffset);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of EpochEndOffset");
            }
            _size.addBytes(2);
            _size.addBytes(4);
            if (_version >= 1) {
                _size.addBytes(4);
            }
            _size.addBytes(8);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EpochEndOffset)) {
                return false;
            }
            EpochEndOffset other = (EpochEndOffset)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.partition != other.partition) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            if (this.endOffset != other.endOffset) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + this.partition;
            hashCode = 31 * hashCode + this.leaderEpoch;
            hashCode = 31 * hashCode + ((int)(this.endOffset >> 32) ^ (int)this.endOffset);
            return hashCode;
        }

        @Override
        public EpochEndOffset duplicate() {
            EpochEndOffset _duplicate = new EpochEndOffset();
            _duplicate.errorCode = this.errorCode;
            _duplicate.partition = this.partition;
            _duplicate.leaderEpoch = this.leaderEpoch;
            _duplicate.endOffset = this.endOffset;
            return _duplicate;
        }

        public String toString() {
            return "EpochEndOffset(errorCode=" + this.errorCode + ", partition=" + this.partition + ", leaderEpoch=" + this.leaderEpoch + ", endOffset=" + this.endOffset + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public int partition() {
            return this.partition;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public long endOffset() {
            return this.endOffset;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public EpochEndOffset setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public EpochEndOffset setPartition(int v) {
            this.partition = v;
            return this;
        }

        public EpochEndOffset setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public EpochEndOffset setEndOffset(long v) {
            this.endOffset = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("error_code", Type.INT16, "The error code 0, or if there was no error."), new Field("partition", Type.INT32, "The partition index."), new Field("leader_epoch", Type.INT32, "The leader epoch of the partition."), new Field("end_offset", Type.INT64, "The end offset of the epoch.")));
            SCHEMA_4 = new Schema(new Field("error_code", Type.INT16, "The error code 0, or if there was no error."), new Field("partition", Type.INT32, "The partition index."), new Field("leader_epoch", Type.INT32, "The leader epoch of the partition."), new Field("end_offset", Type.INT64, "The end offset of the epoch."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
        }
    }

    public static class OffsetForLeaderTopicResult
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String topic;
        List<EpochEndOffset> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(EpochEndOffset.SCHEMA_0), "Each partition in the topic we fetched offsets for."));
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 4;

        public OffsetForLeaderTopicResult(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public OffsetForLeaderTopicResult() {
            this.topic = "";
            this.partitions = new ArrayList<EpochEndOffset>(0);
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 4;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<EpochEndOffset> newCollection;
            int arrayLength;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OffsetForLeaderTopicResult");
            }
            int length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _readable.readString(length);
            if (_version >= 4) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new EpochEndOffset(_readable, _version));
                }
                this.partitions = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList<EpochEndOffset>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new EpochEndOffset(_readable, _version));
                }
                this.partitions = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.topic);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(this.partitions.size() + 1);
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    EpochEndOffset partitionsElement = (EpochEndOffset)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.partitions.size());
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    EpochEndOffset partitionsElement = (EpochEndOffset)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of OffsetForLeaderTopicResult");
            }
            byte[] _stringBytes = this.topic.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            if (_version >= 4) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (EpochEndOffset partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof OffsetForLeaderTopicResult)) {
                return false;
            }
            OffsetForLeaderTopicResult other = (OffsetForLeaderTopicResult)obj;
            return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetForLeaderTopicResult)) {
                return false;
            }
            OffsetForLeaderTopicResult other = (OffsetForLeaderTopicResult)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            return hashCode;
        }

        @Override
        public OffsetForLeaderTopicResult duplicate() {
            OffsetForLeaderTopicResult _duplicate = new OffsetForLeaderTopicResult();
            _duplicate.topic = this.topic;
            ArrayList<EpochEndOffset> newPartitions = new ArrayList<EpochEndOffset>(this.partitions.size());
            for (EpochEndOffset _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "OffsetForLeaderTopicResult(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String topic() {
            return this.topic;
        }

        public List<EpochEndOffset> partitions() {
            return this.partitions;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public OffsetForLeaderTopicResult setTopic(String v) {
            this.topic = v;
            return this;
        }

        public OffsetForLeaderTopicResult setPartitions(List<EpochEndOffset> v) {
            this.partitions = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("topic", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(EpochEndOffset.SCHEMA_1), "Each partition in the topic we fetched offsets for.")));
            SCHEMA_4 = new Schema(new Field("topic", Type.COMPACT_STRING, "The topic name."), new Field("partitions", new CompactArrayOf(EpochEndOffset.SCHEMA_4), "Each partition in the topic we fetched offsets for."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
        }
    }
}

