/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.record;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.KafkaException;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.network.TransferableChannel;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.record.AbstractRecords;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.record.ConvertedRecords;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.record.FileLogInputStream;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.record.MemoryRecords;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.record.Record;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.record.RecordBatch;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.record.RecordBatchIterator;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.record.RecordConversionStats;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.record.Records;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.record.RecordsUtil;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.record.UnalignedFileRecords;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.AbstractIterator;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.Time;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.Utils;

public class FileRecords
extends AbstractRecords
implements Closeable {
    private final boolean isSlice;
    private final int start;
    private final int end;
    private final Iterable<FileLogInputStream.FileChannelRecordBatch> batches;
    private final AtomicInteger size;
    private final FileChannel channel;
    private volatile File file;

    FileRecords(File file, FileChannel channel, int start, int end, boolean isSlice) throws IOException {
        this.file = file;
        this.channel = channel;
        this.start = start;
        this.end = end;
        this.isSlice = isSlice;
        this.size = new AtomicInteger();
        if (isSlice) {
            this.size.set(end - start);
        } else {
            if (channel.size() > Integer.MAX_VALUE) {
                throw new KafkaException("The size of segment " + file + " (" + channel.size() + ") is larger than the maximum allowed segment size of " + Integer.MAX_VALUE);
            }
            int limit = Math.min((int)channel.size(), end);
            this.size.set(limit - start);
            channel.position(limit);
        }
        this.batches = this.batchesFrom(start);
    }

    @Override
    public int sizeInBytes() {
        return this.size.get();
    }

    public File file() {
        return this.file;
    }

    public FileChannel channel() {
        return this.channel;
    }

    public void readInto(ByteBuffer buffer, int position) throws IOException {
        Utils.readFully(this.channel, buffer, position + this.start);
        buffer.flip();
    }

    public FileRecords slice(int position, int size) throws IOException {
        int availableBytes = this.availableBytes(position, size);
        int startPosition = this.start + position;
        return new FileRecords(this.file, this.channel, startPosition, startPosition + availableBytes, true);
    }

    public UnalignedFileRecords sliceUnaligned(int position, int size) {
        int availableBytes = this.availableBytes(position, size);
        return new UnalignedFileRecords(this.channel, this.start + position, availableBytes);
    }

    private int availableBytes(int position, int size) {
        int currentSizeInBytes = this.sizeInBytes();
        if (position < 0) {
            throw new IllegalArgumentException("Invalid position: " + position + " in read from " + this);
        }
        if (position > currentSizeInBytes - this.start) {
            throw new IllegalArgumentException("Slice from position " + position + " exceeds end position of " + this);
        }
        if (size < 0) {
            throw new IllegalArgumentException("Invalid size: " + size + " in read from " + this);
        }
        int end = this.start + position + size;
        if (end < 0 || end > this.start + currentSizeInBytes) {
            end = this.start + currentSizeInBytes;
        }
        return end - (this.start + position);
    }

    public int append(MemoryRecords records) throws IOException {
        if (records.sizeInBytes() > Integer.MAX_VALUE - this.size.get()) {
            throw new IllegalArgumentException("Append of size " + records.sizeInBytes() + " bytes is too large for segment with current file position at " + this.size.get());
        }
        int written = records.writeFullyTo(this.channel);
        this.size.getAndAdd(written);
        return written;
    }

    public void flush() throws IOException {
        this.channel.force(true);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.trim();
        this.channel.close();
    }

    public void closeHandlers() throws IOException {
        this.channel.close();
    }

    public boolean deleteIfExists() throws IOException {
        Utils.closeQuietly(this.channel, "FileChannel");
        return Files.deleteIfExists(this.file.toPath());
    }

    public void trim() throws IOException {
        this.truncateTo(this.sizeInBytes());
    }

    public void updateParentDir(File parentDir) {
        this.file = new File(parentDir, this.file.getName());
    }

    public void renameTo(File f) throws IOException {
        try {
            Utils.atomicMoveWithFallback(this.file.toPath(), f.toPath(), false);
        }
        finally {
            this.file = f;
        }
    }

    public int truncateTo(int targetSize) throws IOException {
        int originalSize = this.sizeInBytes();
        if (targetSize > originalSize || targetSize < 0) {
            throw new KafkaException("Attempt to truncate log segment " + this.file + " to " + targetSize + " bytes failed,  size of this log segment is " + originalSize + " bytes.");
        }
        if (targetSize < (int)this.channel.size()) {
            this.channel.truncate(targetSize);
            this.size.set(targetSize);
        }
        return originalSize - targetSize;
    }

    @Override
    public ConvertedRecords<? extends Records> downConvert(byte toMagic, long firstOffset, Time time) {
        ConvertedRecords<MemoryRecords> convertedRecords = RecordsUtil.downConvert(this.batches, toMagic, firstOffset, time);
        if (convertedRecords.recordConversionStats().numRecordsConverted() == 0) {
            return new ConvertedRecords<FileRecords>(this, RecordConversionStats.EMPTY);
        }
        return convertedRecords;
    }

    @Override
    public long writeTo(TransferableChannel destChannel, long offset, int length) throws IOException {
        int oldSize;
        long newSize = Math.min(this.channel.size(), (long)this.end) - (long)this.start;
        if (newSize < (long)(oldSize = this.sizeInBytes())) {
            throw new KafkaException(String.format("Size of FileRecords %s has been truncated during write: old size %d, new size %d", this.file.getAbsolutePath(), oldSize, newSize));
        }
        long position = (long)this.start + offset;
        long count = Math.min((long)length, (long)oldSize - offset);
        return destChannel.transferFrom(this.channel, position, count);
    }

    public LogOffsetPosition searchForOffsetWithSize(long targetOffset, int startingPosition) {
        for (FileLogInputStream.FileChannelRecordBatch batch : this.batchesFrom(startingPosition)) {
            long offset = batch.lastOffset();
            if (offset < targetOffset) continue;
            return new LogOffsetPosition(offset, batch.position(), batch.sizeInBytes());
        }
        return null;
    }

    public TimestampAndOffset searchForTimestamp(long targetTimestamp, int startingPosition, long startingOffset) {
        for (RecordBatch recordBatch : this.batchesFrom(startingPosition)) {
            if (recordBatch.maxTimestamp() < targetTimestamp) continue;
            for (Record record : recordBatch) {
                long timestamp = record.timestamp();
                if (timestamp < targetTimestamp || record.offset() < startingOffset) continue;
                return new TimestampAndOffset(timestamp, record.offset(), this.maybeLeaderEpoch(recordBatch.partitionLeaderEpoch()));
            }
        }
        return null;
    }

    public TimestampAndOffset largestTimestampAfter(int startingPosition) {
        long maxTimestamp = -1L;
        long offsetOfMaxTimestamp = -1L;
        int leaderEpochOfMaxTimestamp = -1;
        for (RecordBatch recordBatch : this.batchesFrom(startingPosition)) {
            long timestamp = recordBatch.maxTimestamp();
            if (timestamp <= maxTimestamp) continue;
            maxTimestamp = timestamp;
            offsetOfMaxTimestamp = recordBatch.lastOffset();
            leaderEpochOfMaxTimestamp = recordBatch.partitionLeaderEpoch();
        }
        return new TimestampAndOffset(maxTimestamp, offsetOfMaxTimestamp, this.maybeLeaderEpoch(leaderEpochOfMaxTimestamp));
    }

    private Optional<Integer> maybeLeaderEpoch(int leaderEpoch) {
        return leaderEpoch == -1 ? Optional.empty() : Optional.of(leaderEpoch);
    }

    public Iterable<FileLogInputStream.FileChannelRecordBatch> batches() {
        return this.batches;
    }

    public String toString() {
        return "FileRecords(size=" + this.sizeInBytes() + ", file=" + this.file + ", start=" + this.start + ", end=" + this.end + ")";
    }

    public Iterable<FileLogInputStream.FileChannelRecordBatch> batchesFrom(int start) {
        return () -> this.batchIterator(start);
    }

    public AbstractIterator<FileLogInputStream.FileChannelRecordBatch> batchIterator() {
        return this.batchIterator(this.start);
    }

    private AbstractIterator<FileLogInputStream.FileChannelRecordBatch> batchIterator(int start) {
        int end = this.isSlice ? this.end : this.sizeInBytes();
        FileLogInputStream inputStream = new FileLogInputStream(this, start, end);
        return new RecordBatchIterator<FileLogInputStream.FileChannelRecordBatch>(inputStream);
    }

    public static FileRecords open(File file, boolean mutable, boolean fileAlreadyExists, int initFileSize, boolean preallocate) throws IOException {
        FileChannel channel = FileRecords.openChannel(file, mutable, fileAlreadyExists, initFileSize, preallocate);
        int end = !fileAlreadyExists && preallocate ? 0 : Integer.MAX_VALUE;
        return new FileRecords(file, channel, 0, end, false);
    }

    public static FileRecords open(File file, boolean fileAlreadyExists, int initFileSize, boolean preallocate) throws IOException {
        return FileRecords.open(file, true, fileAlreadyExists, initFileSize, preallocate);
    }

    public static FileRecords open(File file, boolean mutable) throws IOException {
        return FileRecords.open(file, mutable, false, 0, false);
    }

    public static FileRecords open(File file) throws IOException {
        return FileRecords.open(file, true);
    }

    private static FileChannel openChannel(File file, boolean mutable, boolean fileAlreadyExists, int initFileSize, boolean preallocate) throws IOException {
        if (mutable) {
            if (fileAlreadyExists || !preallocate) {
                return FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.setLength(initFileSize);
            return randomAccessFile.getChannel();
        }
        return FileChannel.open(file.toPath(), new OpenOption[0]);
    }

    public static class TimestampAndOffset {
        public final long timestamp;
        public final long offset;
        public final Optional<Integer> leaderEpoch;

        public TimestampAndOffset(long timestamp, long offset, Optional<Integer> leaderEpoch) {
            this.timestamp = timestamp;
            this.offset = offset;
            this.leaderEpoch = leaderEpoch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimestampAndOffset that = (TimestampAndOffset)o;
            return this.timestamp == that.timestamp && this.offset == that.offset && Objects.equals(this.leaderEpoch, that.leaderEpoch);
        }

        public int hashCode() {
            return Objects.hash(this.timestamp, this.offset, this.leaderEpoch);
        }

        public String toString() {
            return "TimestampAndOffset(timestamp=" + this.timestamp + ", offset=" + this.offset + ", leaderEpoch=" + this.leaderEpoch + ')';
        }
    }

    public static class LogOffsetPosition {
        public final long offset;
        public final int position;
        public final int size;

        public LogOffsetPosition(long offset, int position, int size) {
            this.offset = offset;
            this.position = position;
            this.size = size;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogOffsetPosition that = (LogOffsetPosition)o;
            return this.offset == that.offset && this.position == that.position && this.size == that.size;
        }

        public int hashCode() {
            int result = Long.hashCode(this.offset);
            result = 31 * result + this.position;
            result = 31 * result + this.size;
            return result;
        }

        public String toString() {
            return "LogOffsetPosition(offset=" + this.offset + ", position=" + this.position + ", size=" + this.size + ')';
        }
    }
}

