/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.clients.admin.internals;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.Node;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests.AbstractResponse;

public interface AdminApiHandler<K, V> {
    public String apiName();

    public Collection<RequestAndKeys<K>> buildRequest(int var1, Set<K> var2);

    public ApiResult<K, V> handleResponse(Node var1, Set<K> var2, AbstractResponse var3);

    public AdminApiLookupStrategy<K> lookupStrategy();

    public static abstract class Unbatched<K, V>
    implements AdminApiHandler<K, V> {
        abstract AbstractRequest.Builder<?> buildSingleRequest(int var1, K var2);

        abstract ApiResult<K, V> handleSingleResponse(Node var1, K var2, AbstractResponse var3);

        @Override
        public final Collection<RequestAndKeys<K>> buildRequest(int brokerId, Set<K> keys) {
            return keys.stream().map(key -> new RequestAndKeys<Object>(this.buildSingleRequest(brokerId, key), Collections.singleton(key))).collect(Collectors.toSet());
        }

        @Override
        public final ApiResult<K, V> handleResponse(Node broker, Set<K> keys, AbstractResponse response) {
            if (keys.size() != 1) {
                throw new IllegalArgumentException("Unbatched admin handler should only be required to handle responses for a single key at a time");
            }
            K key = keys.iterator().next();
            return this.handleSingleResponse(broker, key, response);
        }
    }

    public static abstract class Batched<K, V>
    implements AdminApiHandler<K, V> {
        abstract AbstractRequest.Builder<?> buildBatchedRequest(int var1, Set<K> var2);

        @Override
        public final Collection<RequestAndKeys<K>> buildRequest(int brokerId, Set<K> keys) {
            return Collections.singleton(new RequestAndKeys<K>(this.buildBatchedRequest(brokerId, keys), keys));
        }
    }

    public static class RequestAndKeys<K> {
        public final AbstractRequest.Builder<?> request;
        public final Set<K> keys;

        public RequestAndKeys(AbstractRequest.Builder<?> request, Set<K> keys) {
            this.request = request;
            this.keys = keys;
        }
    }

    public static class ApiResult<K, V> {
        public final Map<K, V> completedKeys;
        public final Map<K, Throwable> failedKeys;
        public final List<K> unmappedKeys;

        public ApiResult(Map<K, V> completedKeys, Map<K, Throwable> failedKeys, List<K> unmappedKeys) {
            this.completedKeys = Collections.unmodifiableMap(completedKeys);
            this.failedKeys = Collections.unmodifiableMap(failedKeys);
            this.unmappedKeys = Collections.unmodifiableList(unmappedKeys);
        }

        public static <K, V> ApiResult<K, V> completed(K key, V value) {
            return new ApiResult<K, V>(Collections.singletonMap(key, value), Collections.emptyMap(), Collections.emptyList());
        }

        public static <K, V> ApiResult<K, V> failed(K key, Throwable t) {
            return new ApiResult(Collections.emptyMap(), Collections.singletonMap(key, t), Collections.emptyList());
        }

        public static <K, V> ApiResult<K, V> unmapped(List<K> keys) {
            return new ApiResult(Collections.emptyMap(), Collections.emptyMap(), keys);
        }

        public static <K, V> ApiResult<K, V> empty() {
            return new ApiResult(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList());
        }
    }
}

