/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.clients.admin;

import java.util.Map;
import java.util.Set;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.clients.ClientDnsLookup;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.clients.CommonClientConfigs;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.config.AbstractConfig;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.config.ConfigDef;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.metrics.Sensor;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.Utils;

public class AdminClientConfig
extends AbstractConfig {
    private static final ConfigDef CONFIG;
    public static final String BOOTSTRAP_SERVERS_CONFIG = "bootstrap.servers";
    private static final String BOOTSTRAP_SERVERS_DOC = "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).";
    public static final String CLIENT_DNS_LOOKUP_CONFIG = "client.dns.lookup";
    private static final String CLIENT_DNS_LOOKUP_DOC = "Controls how the client uses DNS lookups. If set to <code>use_all_dns_ips</code>, connect to each returned IP address in sequence until a successful connection is established. After a disconnection, the next IP is used. Once all IPs have been used once, the client resolves the IP(s) from the hostname again (both the JVM and the OS cache DNS name lookups, however). If set to <code>resolve_canonical_bootstrap_servers_only</code>, resolve each bootstrap address into a list of canonical names. After the bootstrap phase, this behaves the same as <code>use_all_dns_ips</code>.";
    public static final String RECONNECT_BACKOFF_MS_CONFIG = "reconnect.backoff.ms";
    private static final String RECONNECT_BACKOFF_MS_DOC = "The base amount of time to wait before attempting to reconnect to a given host. This avoids repeatedly connecting to a host in a tight loop. This backoff applies to all connection attempts by the client to a broker.";
    public static final String RECONNECT_BACKOFF_MAX_MS_CONFIG = "reconnect.backoff.max.ms";
    private static final String RECONNECT_BACKOFF_MAX_MS_DOC = "The maximum amount of time in milliseconds to wait when reconnecting to a broker that has repeatedly failed to connect. If provided, the backoff per host will increase exponentially for each consecutive connection failure, up to this maximum. After calculating the backoff increase, 20% random jitter is added to avoid connection storms.";
    public static final String RETRY_BACKOFF_MS_CONFIG = "retry.backoff.ms";
    private static final String RETRY_BACKOFF_MS_DOC = "The amount of time to wait before attempting to retry a failed request. This avoids repeatedly sending requests in a tight loop under some failure scenarios.";
    public static final String SOCKET_CONNECTION_SETUP_TIMEOUT_MS_CONFIG = "socket.connection.setup.timeout.ms";
    public static final String SOCKET_CONNECTION_SETUP_TIMEOUT_MAX_MS_CONFIG = "socket.connection.setup.timeout.max.ms";
    public static final String CONNECTIONS_MAX_IDLE_MS_CONFIG = "connections.max.idle.ms";
    private static final String CONNECTIONS_MAX_IDLE_MS_DOC = "Close idle connections after the number of milliseconds specified by this config.";
    public static final String REQUEST_TIMEOUT_MS_CONFIG = "request.timeout.ms";
    private static final String REQUEST_TIMEOUT_MS_DOC = "The configuration controls the maximum amount of time the client will wait for the response of a request. If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.";
    public static final String CLIENT_ID_CONFIG = "client.id";
    private static final String CLIENT_ID_DOC = "An id string to pass to the server when making requests. The purpose of this is to be able to track the source of requests beyond just ip/port by allowing a logical application name to be included in server-side request logging.";
    public static final String METADATA_MAX_AGE_CONFIG = "metadata.max.age.ms";
    private static final String METADATA_MAX_AGE_DOC = "The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.";
    public static final String SEND_BUFFER_CONFIG = "send.buffer.bytes";
    private static final String SEND_BUFFER_DOC = "The size of the TCP send buffer (SO_SNDBUF) to use when sending data. If the value is -1, the OS default will be used.";
    public static final String RECEIVE_BUFFER_CONFIG = "receive.buffer.bytes";
    private static final String RECEIVE_BUFFER_DOC = "The size of the TCP receive buffer (SO_RCVBUF) to use when reading data. If the value is -1, the OS default will be used.";
    public static final String METRIC_REPORTER_CLASSES_CONFIG = "metric.reporters";
    private static final String METRIC_REPORTER_CLASSES_DOC = "A list of classes to use as metrics reporters. Implementing the <code>org.apache.kafka.common.metrics.MetricsReporter</code> interface allows plugging in classes that will be notified of new metric creation. The JmxReporter is always included to register JMX statistics.";
    @Deprecated
    public static final String AUTO_INCLUDE_JMX_REPORTER_CONFIG = "auto.include.jmx.reporter";
    public static final String AUTO_INCLUDE_JMX_REPORTER_DOC = "Deprecated. Whether to automatically include JmxReporter even if it's not listed in <code>metric.reporters</code>. This configuration will be removed in Kafka 4.0, users should instead include <code>org.apache.kafka.common.metrics.JmxReporter</code> in <code>metric.reporters</code> in order to enable the JmxReporter.";
    public static final String METRICS_NUM_SAMPLES_CONFIG = "metrics.num.samples";
    private static final String METRICS_NUM_SAMPLES_DOC = "The number of samples maintained to compute metrics.";
    public static final String METRICS_SAMPLE_WINDOW_MS_CONFIG = "metrics.sample.window.ms";
    private static final String METRICS_SAMPLE_WINDOW_MS_DOC = "The window of time a metrics sample is computed over.";
    public static final String METRICS_RECORDING_LEVEL_CONFIG = "metrics.recording.level";
    public static final String SECURITY_PROTOCOL_CONFIG = "security.protocol";
    public static final String DEFAULT_SECURITY_PROTOCOL = "PLAINTEXT";
    private static final String SECURITY_PROTOCOL_DOC;
    private static final String METRICS_RECORDING_LEVEL_DOC = "The highest recording level for metrics.";
    public static final String RETRIES_CONFIG = "retries";
    public static final String DEFAULT_API_TIMEOUT_MS_CONFIG = "default.api.timeout.ms";
    public static final String SECURITY_PROVIDERS_CONFIG = "security.providers";
    private static final String SECURITY_PROVIDERS_DOC = "A list of configurable creator classes each returning a provider implementing security algorithms. These classes should implement the <code>org.apache.kafka.common.security.auth.SecurityProviderCreator</code> interface.";

    @Override
    protected Map<String, Object> postProcessParsedConfig(Map<String, Object> parsedValues) {
        CommonClientConfigs.postValidateSaslMechanismConfig(this);
        return CommonClientConfigs.postProcessReconnectBackoffConfigs(this, parsedValues);
    }

    public AdminClientConfig(Map<?, ?> props) {
        this(props, false);
    }

    protected AdminClientConfig(Map<?, ?> props, boolean doLog) {
        super(CONFIG, props, doLog);
    }

    public static Set<String> configNames() {
        return CONFIG.names();
    }

    public static ConfigDef configDef() {
        return new ConfigDef(CONFIG);
    }

    public static void main(String[] args) {
        System.out.println(CONFIG.toHtml(4, config -> "adminclientconfigs_" + config));
    }

    static {
        SECURITY_PROTOCOL_DOC = CommonClientConfigs.SECURITY_PROTOCOL_DOC;
        CONFIG = new ConfigDef().define(BOOTSTRAP_SERVERS_CONFIG, ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, BOOTSTRAP_SERVERS_DOC).define(CLIENT_ID_CONFIG, ConfigDef.Type.STRING, "", ConfigDef.Importance.MEDIUM, CLIENT_ID_DOC).define(METADATA_MAX_AGE_CONFIG, ConfigDef.Type.LONG, 300000, ConfigDef.Range.atLeast(0), ConfigDef.Importance.LOW, METADATA_MAX_AGE_DOC).define(SEND_BUFFER_CONFIG, ConfigDef.Type.INT, 131072, ConfigDef.Range.atLeast(-1), ConfigDef.Importance.MEDIUM, SEND_BUFFER_DOC).define(RECEIVE_BUFFER_CONFIG, ConfigDef.Type.INT, 65536, ConfigDef.Range.atLeast(-1), ConfigDef.Importance.MEDIUM, RECEIVE_BUFFER_DOC).define(RECONNECT_BACKOFF_MS_CONFIG, ConfigDef.Type.LONG, 50L, ConfigDef.Range.atLeast(0L), ConfigDef.Importance.LOW, RECONNECT_BACKOFF_MS_DOC).define(RECONNECT_BACKOFF_MAX_MS_CONFIG, ConfigDef.Type.LONG, 1000L, ConfigDef.Range.atLeast(0L), ConfigDef.Importance.LOW, RECONNECT_BACKOFF_MAX_MS_DOC).define(RETRY_BACKOFF_MS_CONFIG, ConfigDef.Type.LONG, 100L, ConfigDef.Range.atLeast(0L), ConfigDef.Importance.LOW, RETRY_BACKOFF_MS_DOC).define(REQUEST_TIMEOUT_MS_CONFIG, ConfigDef.Type.INT, 30000, ConfigDef.Range.atLeast(0), ConfigDef.Importance.MEDIUM, REQUEST_TIMEOUT_MS_DOC).define(SOCKET_CONNECTION_SETUP_TIMEOUT_MS_CONFIG, ConfigDef.Type.LONG, CommonClientConfigs.DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT_MS, ConfigDef.Importance.MEDIUM, "The amount of time the client will wait for the socket connection to be established. If the connection is not built before the timeout elapses, clients will close the socket channel.").define(SOCKET_CONNECTION_SETUP_TIMEOUT_MAX_MS_CONFIG, ConfigDef.Type.LONG, CommonClientConfigs.DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT_MAX_MS, ConfigDef.Importance.MEDIUM, "The maximum amount of time the client will wait for the socket connection to be established. The connection setup timeout will increase exponentially for each consecutive connection failure up to this maximum. To avoid connection storms, a randomization factor of 0.2 will be applied to the timeout resulting in a random range between 20% below and 20% above the computed value.").define(CONNECTIONS_MAX_IDLE_MS_CONFIG, ConfigDef.Type.LONG, 300000, ConfigDef.Importance.MEDIUM, CONNECTIONS_MAX_IDLE_MS_DOC).define(RETRIES_CONFIG, ConfigDef.Type.INT, Integer.MAX_VALUE, ConfigDef.Range.between(0, Integer.MAX_VALUE), ConfigDef.Importance.LOW, "Setting a value greater than zero will cause the client to resend any request that fails with a potentially transient error. It is recommended to set the value to either zero or `MAX_VALUE` and use corresponding timeout parameters to control how long a client should retry a request.").define(DEFAULT_API_TIMEOUT_MS_CONFIG, ConfigDef.Type.INT, 60000, ConfigDef.Range.atLeast(0), ConfigDef.Importance.MEDIUM, "Specifies the timeout (in milliseconds) for client APIs. This configuration is used as the default timeout for all client operations that do not specify a <code>timeout</code> parameter.").define(METRICS_SAMPLE_WINDOW_MS_CONFIG, ConfigDef.Type.LONG, 30000, ConfigDef.Range.atLeast(0), ConfigDef.Importance.LOW, METRICS_SAMPLE_WINDOW_MS_DOC).define(METRICS_NUM_SAMPLES_CONFIG, ConfigDef.Type.INT, 2, ConfigDef.Range.atLeast(1), ConfigDef.Importance.LOW, METRICS_NUM_SAMPLES_DOC).define(METRIC_REPORTER_CLASSES_CONFIG, ConfigDef.Type.LIST, "", ConfigDef.Importance.LOW, METRIC_REPORTER_CLASSES_DOC).define(METRICS_RECORDING_LEVEL_CONFIG, ConfigDef.Type.STRING, Sensor.RecordingLevel.INFO.toString(), ConfigDef.ValidString.in(Sensor.RecordingLevel.INFO.toString(), Sensor.RecordingLevel.DEBUG.toString(), Sensor.RecordingLevel.TRACE.toString()), ConfigDef.Importance.LOW, METRICS_RECORDING_LEVEL_DOC).define(AUTO_INCLUDE_JMX_REPORTER_CONFIG, ConfigDef.Type.BOOLEAN, true, ConfigDef.Importance.LOW, AUTO_INCLUDE_JMX_REPORTER_DOC).define(CLIENT_DNS_LOOKUP_CONFIG, ConfigDef.Type.STRING, ClientDnsLookup.USE_ALL_DNS_IPS.toString(), ConfigDef.ValidString.in(ClientDnsLookup.USE_ALL_DNS_IPS.toString(), ClientDnsLookup.RESOLVE_CANONICAL_BOOTSTRAP_SERVERS_ONLY.toString()), ConfigDef.Importance.MEDIUM, CLIENT_DNS_LOOKUP_DOC).define(SECURITY_PROVIDERS_CONFIG, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, SECURITY_PROVIDERS_DOC).define(SECURITY_PROTOCOL_CONFIG, ConfigDef.Type.STRING, DEFAULT_SECURITY_PROTOCOL, ConfigDef.CaseInsensitiveValidString.in(Utils.enumOptions(SecurityProtocol.class)), ConfigDef.Importance.MEDIUM, SECURITY_PROTOCOL_DOC).withClientSslSupport().withClientSaslSupport();
    }
}

