/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.testutil;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.SchemaProvider;
import org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.config.ConfigException;

public final class MockSchemaRegistry {
    private static final String MOCK_URL_PREFIX = "mock://";
    private static final Map<String, SchemaRegistryClient> SCOPED_CLIENTS = new HashMap<String, SchemaRegistryClient>();

    private MockSchemaRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchemaRegistryClient getClientForScope(String scope) {
        Map<String, SchemaRegistryClient> map = SCOPED_CLIENTS;
        synchronized (map) {
            if (!SCOPED_CLIENTS.containsKey(scope)) {
                SCOPED_CLIENTS.put(scope, new MockSchemaRegistryClient());
            }
        }
        return SCOPED_CLIENTS.get(scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchemaRegistryClient getClientForScope(String scope, List<SchemaProvider> providers) {
        Map<String, SchemaRegistryClient> map = SCOPED_CLIENTS;
        synchronized (map) {
            if (!SCOPED_CLIENTS.containsKey(scope)) {
                SCOPED_CLIENTS.put(scope, new MockSchemaRegistryClient(providers));
            }
        }
        return SCOPED_CLIENTS.get(scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropScope(String scope) {
        Map<String, SchemaRegistryClient> map = SCOPED_CLIENTS;
        synchronized (map) {
            SCOPED_CLIENTS.remove(scope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<String, SchemaRegistryClient> map = SCOPED_CLIENTS;
        synchronized (map) {
            SCOPED_CLIENTS.clear();
        }
    }

    public static String validateAndMaybeGetMockScope(List<String> urls) {
        LinkedList<String> mockScopes = new LinkedList<String>();
        for (String url : urls) {
            if (!url.startsWith(MOCK_URL_PREFIX)) continue;
            mockScopes.add(url.substring(MOCK_URL_PREFIX.length()));
        }
        if (mockScopes.isEmpty()) {
            return null;
        }
        if (mockScopes.size() > 1) {
            throw new ConfigException("Only one mock scope is permitted for 'schema.registry.url'. Got: " + urls);
        }
        if (urls.size() > mockScopes.size()) {
            throw new ConfigException("Cannot mix mock and real urls for 'schema.registry.url'. Got: " + urls);
        }
        return (String)mockScopes.get(0);
    }
}

