/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.client.security.bearerauth;

import java.net.URL;
import java.util.Map;
import org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.client.security.bearerauth.BearerAuthCredentialProvider;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.config.ConfigException;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;

public class StaticTokenCredentialProvider
implements BearerAuthCredentialProvider {
    private String bearerToken;
    private String targetSchemaRegistry;
    private String targetIdentityPoolId;

    @Override
    public String alias() {
        return "STATIC_TOKEN";
    }

    @Override
    public String getTargetSchemaRegistry() {
        return this.targetSchemaRegistry;
    }

    @Override
    public String getTargetIdentityPoolId() {
        return this.targetIdentityPoolId;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        ConfigurationUtils cu = new ConfigurationUtils(configs);
        this.targetSchemaRegistry = cu.validateString("bearer.auth.logical.cluster", false);
        this.targetIdentityPoolId = cu.validateString("bearer.auth.identity.pool.id", false);
        this.bearerToken = (String)configs.get("bearer.auth.token");
        if (this.bearerToken != null && !this.bearerToken.isEmpty()) {
            return;
        }
        throw new ConfigException(String.format("Token must be provided via %s config when %s is set to %s", "bearer.auth.token", "bearer.auth.credentials.source", this.alias()));
    }

    @Override
    public String getBearerToken(URL url) {
        return this.bearerToken;
    }
}

