/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.message.ResponseHeaderData;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests.AbstractRequestResponse;

public class ResponseHeader
implements AbstractRequestResponse {
    private static final int SIZE_NOT_INITIALIZED = -1;
    private final ResponseHeaderData data;
    private final short headerVersion;
    private int size = -1;

    public ResponseHeader(int correlationId, short headerVersion) {
        this(new ResponseHeaderData().setCorrelationId(correlationId), headerVersion);
    }

    public ResponseHeader(ResponseHeaderData data, short headerVersion) {
        this.data = data;
        this.headerVersion = headerVersion;
    }

    int size(ObjectSerializationCache serializationCache) {
        return this.data().size(serializationCache, this.headerVersion);
    }

    public int size() {
        if (this.size == -1) {
            this.size = this.size(new ObjectSerializationCache());
        }
        return this.size;
    }

    public int correlationId() {
        return this.data.correlationId();
    }

    public short headerVersion() {
        return this.headerVersion;
    }

    @Override
    public ResponseHeaderData data() {
        return this.data;
    }

    void write(ByteBuffer buffer, ObjectSerializationCache serializationCache) {
        this.data.write(new ByteBufferAccessor(buffer), serializationCache, this.headerVersion);
    }

    public String toString() {
        return "ResponseHeader(correlationId=" + this.data.correlationId() + ", headerVersion=" + this.headerVersion + ")";
    }

    public static ResponseHeader parse(ByteBuffer buffer, short headerVersion) {
        int bufferStartPositionForHeader = buffer.position();
        ResponseHeader header = new ResponseHeader(new ResponseHeaderData(new ByteBufferAccessor(buffer), headerVersion), headerVersion);
        header.size = Math.max(buffer.position() - bufferStartPositionForHeader, 0);
        return header;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseHeader that = (ResponseHeader)o;
        return this.headerVersion == that.headerVersion && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.headerVersion);
    }
}

