/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.clients.producer.internals;

import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.clients.producer.internals.TxnPartitionEntry;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.PrimitiveRef;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.ProducerIdAndEpoch;

class TxnPartitionMap {
    final Map<TopicPartition, TxnPartitionEntry> topicPartitions = new HashMap<TopicPartition, TxnPartitionEntry>();

    TxnPartitionMap() {
    }

    TxnPartitionEntry get(TopicPartition topicPartition) {
        TxnPartitionEntry ent = this.topicPartitions.get(topicPartition);
        if (ent == null) {
            throw new IllegalStateException("Trying to get the sequence number for " + topicPartition + ", but the sequence number was never set for this partition.");
        }
        return ent;
    }

    TxnPartitionEntry getOrCreate(TopicPartition topicPartition) {
        return this.topicPartitions.computeIfAbsent(topicPartition, tp -> new TxnPartitionEntry());
    }

    boolean contains(TopicPartition topicPartition) {
        return this.topicPartitions.containsKey(topicPartition);
    }

    void reset() {
        this.topicPartitions.clear();
    }

    OptionalLong lastAckedOffset(TopicPartition topicPartition) {
        TxnPartitionEntry entry = this.topicPartitions.get(topicPartition);
        if (entry != null && entry.lastAckedOffset != -1L) {
            return OptionalLong.of(entry.lastAckedOffset);
        }
        return OptionalLong.empty();
    }

    OptionalInt lastAckedSequence(TopicPartition topicPartition) {
        TxnPartitionEntry entry = this.topicPartitions.get(topicPartition);
        if (entry != null && entry.lastAckedSequence != -1) {
            return OptionalInt.of(entry.lastAckedSequence);
        }
        return OptionalInt.empty();
    }

    void startSequencesAtBeginning(TopicPartition topicPartition, ProducerIdAndEpoch newProducerIdAndEpoch) {
        PrimitiveRef.IntRef sequence = PrimitiveRef.ofInt(0);
        TxnPartitionEntry topicPartitionEntry = this.get(topicPartition);
        topicPartitionEntry.resetSequenceNumbers(inFlightBatch -> {
            inFlightBatch.resetProducerState(newProducerIdAndEpoch, sequence.value, inFlightBatch.isTransactional());
            sequence.value += inFlightBatch.recordCount;
        });
        topicPartitionEntry.producerIdAndEpoch = newProducerIdAndEpoch;
        topicPartitionEntry.nextSequence = sequence.value;
        topicPartitionEntry.lastAckedSequence = -1;
    }
}

