/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.utils;

import com.google.common.base.CharMatcher;
import java.util.Objects;

public class QualifiedSubject
implements Comparable<QualifiedSubject> {
    public static final String DEFAULT_TENANT = "default";
    public static final String DEFAULT_CONTEXT = ".";
    public static final String TENANT_DELIMITER = "_";
    public static final String CONTEXT_DELIMITER = ":";
    public static final String CONTEXT_SEPARATOR = ".";
    public static final String CONTEXT_PREFIX = ":.";
    public static final String WILDCARD = "*";
    public static final String CONTEXT_WILDCARD = ":*:";
    public static final String GLOBAL_SUBJECT_NAME = "__GLOBAL";
    private final String tenant;
    private final String context;
    private final String subject;

    protected QualifiedSubject(String tenant, String qualifiedSubject) {
        String subject;
        String context;
        String contextSubject;
        String string = contextSubject = qualifiedSubject != null ? qualifiedSubject : "";
        if (!DEFAULT_TENANT.equals(tenant)) {
            int ix = contextSubject.indexOf(TENANT_DELIMITER);
            if (ix >= 0) {
                String tenantPrefix = contextSubject.substring(0, ix);
                contextSubject = contextSubject.substring(ix + 1);
                tenant = tenantPrefix;
            } else {
                tenant = DEFAULT_TENANT;
            }
        }
        if (contextSubject.startsWith(CONTEXT_PREFIX)) {
            int ix = contextSubject.substring(CONTEXT_PREFIX.length()).indexOf(CONTEXT_DELIMITER);
            if (ix >= 0) {
                context = contextSubject.substring(1, ix += CONTEXT_PREFIX.length());
                subject = contextSubject.substring(ix + 1);
            } else {
                context = contextSubject.substring(1);
                subject = "";
            }
        } else if (contextSubject.startsWith(CONTEXT_WILDCARD)) {
            context = WILDCARD;
            subject = contextSubject.substring(CONTEXT_WILDCARD.length());
        } else {
            context = ".";
            subject = contextSubject;
        }
        this.tenant = tenant;
        this.context = context;
        this.subject = subject;
    }

    public QualifiedSubject(String tenant, String context, String subject) {
        this.tenant = tenant != null ? tenant : DEFAULT_TENANT;
        this.context = context != null ? context : ".";
        this.subject = subject != null ? subject : "";
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getContext() {
        return this.context;
    }

    public String getSubject() {
        return this.subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifiedSubject that = (QualifiedSubject)o;
        return Objects.equals(this.tenant, that.tenant) && Objects.equals(this.context, that.context) && Objects.equals(this.subject, that.subject);
    }

    public int hashCode() {
        return Objects.hash(this.tenant, this.context, this.subject);
    }

    public String toString() {
        return this.toQualifiedSubject();
    }

    public String toQualifiedContext() {
        String qualifiedContext;
        String string = qualifiedContext = ".".equals(this.context) ? "" : CONTEXT_DELIMITER + this.context + CONTEXT_DELIMITER;
        if (DEFAULT_TENANT.equals(this.tenant)) {
            return qualifiedContext;
        }
        return this.tenant + TENANT_DELIMITER + qualifiedContext;
    }

    public String toQualifiedSubject() {
        return this.toQualifiedContext() + this.subject;
    }

    public static QualifiedSubject create(String tenant, String qualifiedSubject) {
        try {
            return qualifiedSubject != null ? new QualifiedSubject(tenant, qualifiedSubject) : null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static String contextFor(String tenant, String qualifiedSubject) {
        QualifiedSubject qs = QualifiedSubject.create(tenant, qualifiedSubject);
        return qs != null ? qs.getContext() : ".";
    }

    public static String qualifiedContextFor(String tenant, String qualifiedSubject) {
        QualifiedSubject qs = QualifiedSubject.create(tenant, qualifiedSubject);
        return qs != null ? qs.toQualifiedContext() : "";
    }

    public static QualifiedSubject qualifySubjectWithParent(String tenant, String parent, String subjectWithoutTenant) {
        boolean isQualified;
        QualifiedSubject qualifiedSubject = QualifiedSubject.create(DEFAULT_TENANT, subjectWithoutTenant);
        if (qualifiedSubject == null) {
            return null;
        }
        boolean bl = isQualified = !".".equals(qualifiedSubject.getContext());
        if (!isQualified) {
            boolean isParentQualified;
            QualifiedSubject qualifiedParent = QualifiedSubject.create(tenant, parent);
            boolean bl2 = isParentQualified = qualifiedParent != null && !".".equals(qualifiedParent.getContext());
            if (isParentQualified) {
                qualifiedSubject = new QualifiedSubject(DEFAULT_TENANT, qualifiedParent.getContext(), subjectWithoutTenant);
            }
        }
        return qualifiedSubject;
    }

    public static String normalize(String tenant, String qualifiedSubject) {
        QualifiedSubject qs = QualifiedSubject.create(tenant, qualifiedSubject);
        return qs != null ? qs.toQualifiedSubject() : null;
    }

    public static String normalizeContext(String context) {
        if (context == null) {
            return null;
        }
        if (context.startsWith(CONTEXT_DELIMITER)) {
            context = context.substring(1);
        }
        if (context.endsWith(CONTEXT_DELIMITER)) {
            context = context.substring(0, context.length() - 1);
        }
        if (context.contains(CONTEXT_DELIMITER)) {
            throw new IllegalArgumentException("Context name cannot contain a colon");
        }
        if (!context.startsWith(".")) {
            context = "." + context;
        }
        return ".".equals(context) ? "" : CONTEXT_DELIMITER + context + CONTEXT_DELIMITER;
    }

    public static boolean isValidSubject(String tenant, String qualifiedSubject) {
        if (qualifiedSubject == null || CharMatcher.javaIsoControl().matchesAnyOf(qualifiedSubject)) {
            return false;
        }
        QualifiedSubject qs = QualifiedSubject.create(tenant, qualifiedSubject);
        return qs != null && !qs.getSubject().equals(GLOBAL_SUBJECT_NAME);
    }

    @Override
    public int compareTo(QualifiedSubject that) {
        if (this.getTenant() != null || that.getTenant() != null) {
            if (this.getTenant() == null) {
                return -1;
            }
            if (that.getTenant() == null) {
                return 1;
            }
            int tenantComparison = this.getTenant().compareTo(that.getTenant());
            if (tenantComparison != 0) {
                return tenantComparison < 0 ? -1 : 1;
            }
        }
        if (this.getContext() != null || that.getContext() != null) {
            if (this.getContext() == null) {
                return -1;
            }
            if (that.getContext() == null) {
                return 1;
            }
            int contextComparison = this.getContext().compareTo(that.getContext());
            if (contextComparison != 0) {
                return contextComparison < 0 ? -1 : 1;
            }
        }
        if (this.getSubject() == null && that.getSubject() == null) {
            return 0;
        }
        if (this.getSubject() == null) {
            return -1;
        }
        if (that.getSubject() == null) {
            return 1;
        }
        return this.getSubject().compareTo(that.getSubject());
    }
}

